/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.service.dms.YamDms;
import com.anahata.yam.service.dms.push.DmsEventPublisher;
import com.anahata.yam.service.dms.storage.StorageService;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@TransactionManagement(value=TransactionManagementType.BEAN)
public class RevisionCopyBatch {
    private static final Logger log = LoggerFactory.getLogger(RevisionCopyBatch.class);
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    private ServerConfig sc;
    @Resource
    private UserTransaction ut;
    @Inject
    private StorageService storage;
    @Inject
    @YamDms
    private DmsEventPublisher eventService;

    @Schedule(minute="*", second="*/5", dayOfMonth="*", month="*", year="*", hour="*", dayOfWeek="*", persistent=false)
    void synch(Timer timer) {
        if (!this.sc.isDmsEnabled() || !this.sc.isBatchJobsEnabled()) {
            log.debug("RevisionCopyBatch cancelled as dms or batch jobs not enabled");
            timer.cancel();
            return;
        }
        try {
            this.doSync();
        }
        catch (Throwable e) {
            log.error("Exception syncing revision storage", e);
        }
    }

    private void doSync() throws Exception {
        boolean more = true;
        while (more) {
            try {
                this.ut.begin();
                String query = "Select r From Revision r Where r.synchStatus = :pendingCopy AND r.copyOf.synchStatus = :uploaded";
                List l = this.em.createQuery(query).setParameter("pendingCopy", (Object)RevisionSynchStatus.PENDING_COPY).setParameter("uploaded", (Object)RevisionSynchStatus.UPLOADED).setMaxResults(1).getResultList();
                if (!l.isEmpty()) {
                    Revision r = (Revision)l.get(0);
                    log.info("Copying revision content of: {}", (Object)r);
                    Revision master = r.getCopyOf();
                    byte[] bytes = this.storage.getRevisionBytes(master);
                    boolean success = r.completeUpload(bytes);
                    if (success) {
                        this.eventService.nodesModified((Node[])new Document[]{r.getDocument()});
                    }
                } else {
                    log.debug("No Revisions pending copy: ");
                    more = false;
                }
                this.ut.commit();
            }
            catch (Exception e) {
                log.error("Exception copying revision content", (Throwable)e);
                this.ut.rollback();
            }
        }
    }
}

