/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import com.anahata.yam.tech.Yam;
import java.util.Date;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class NodeSynchServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(NodeSynchServiceHelper.class);
    @Inject
    @Yam
    private EntityManager em;

    @Asynchronous
    public Future<NodeStorage> fireAdapterSynch(@NonNull StorageProviderClient adapter, @NonNull Node node) throws Exception {
        if (adapter == null) {
            throw new NullPointerException("adapter");
        }
        if (node == null) {
            throw new NullPointerException("node");
        }
        log.debug("fireAdaptherSynch starts for {} on {}", (Object)node, adapter.getProvider());
        adapter.synch(node);
        log.debug("fireAdapterSynch completed adapter.synch(node): {} {}", adapter.getProvider(), (Object)node);
        return new AsyncResult((Object)node.getNodeStorage(adapter.getProvider()));
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void continueSynch(long nodeStorageId) {
        NodeStorage ns = (NodeStorage)this.em.find(NodeStorage.class, (Object)nodeStorageId);
        ns.continueSynch();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeSynch(long nodeStorageId, Date synchedChange) {
        NodeStorage ns = (NodeStorage)this.em.find(NodeStorage.class, (Object)nodeStorageId);
        ns.completeSynch(synchedChange);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void failSynch(long nodeStorageId, Throwable cause) {
        NodeStorage ns = (NodeStorage)this.em.find(NodeStorage.class, (Object)nodeStorageId);
        ns.failSynch(cause);
    }
}

