/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.storage;

import com.anahata.util.validation.ValidationUtils;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.model.dms.storage.RevisionStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.service.dms.storage.NodeSynchServiceHelper;
import com.anahata.yam.service.dms.storage.client.StorageProviderClient;
import com.anahata.yam.tech.Yam;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class NodeSynchService {
    private static final Logger log = LoggerFactory.getLogger(NodeSynchService.class);
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    private NodeSynchServiceHelper helper;

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void synch(@NonNull StorageProviderClient adapter, @NonNull NodeStorage ns) throws Exception {
        if (adapter == null) {
            throw new NullPointerException("adapter");
        }
        if (ns == null) {
            throw new NullPointerException("ns");
        }
        Validate.isTrue((!this.em.contains((Object)ns) ? 1 : 0) != 0, (String)" notestorage is managed", (Object[])new Object[0]);
        Date nodeChangedOn = ns.getNode().getChangedOn();
        log.debug("synch will call fireSynch for {} using helper on adapter {}: ", (Object)ns.getNode(), adapter.getProvider());
        long start = System.currentTimeMillis();
        Future<NodeStorage> future = this.helper.fireAdapterSynch(adapter, ns.getNode());
        while (true) {
            long ts;
            try {
                ns = future.get(5L, TimeUnit.SECONDS);
                long ts2 = System.currentTimeMillis() - start;
                log.debug("Synch completed in {} ms. for node {} on provider {}, calling complete synch in new tx", new Object[]{ts2, ns.getNode(), adapter.getProvider()});
                this.helper.completeSynch(ns.getId(), nodeChangedOn);
                log.debug("Synch completed in {} ms. for node {} on provider {}, complete synch in new tx fininshed", new Object[]{ts2, ns.getNode(), adapter.getProvider()});
            }
            catch (TimeoutException e) {
                ts = System.currentTimeMillis() - start;
                log.debug("Synch in progress after {} ms. for node {} on provider {}", new Object[]{ts, ns.getNode(), adapter.getProvider()});
                this.helper.continueSynch(ns.getId());
                continue;
            }
            catch (Throwable e) {
                ts = System.currentTimeMillis() - start;
                log.warn("Synch failed after " + ts + " ms. for node " + ns + " on provider " + adapter.getProvider() + " isSynching=" + ns.isSynching(), e);
                this.helper.failSynch(ns.getId(), e);
            }
            break;
        }
        log.debug("synch exiting for {} on adapter {}: ", (Object)ns.getNode(), adapter.getProvider());
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public NodeStorage initNodeStorage(@NonNull StorageProvider provider, long nodeId) {
        NodeStorage ns;
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        Node node = (Node)this.em.find(Node.class, (Object)nodeId);
        node = (Node)this.em.find(node.getClass(), (Object)nodeId, LockModeType.PESSIMISTIC_WRITE);
        this.em.refresh((Object)node);
        Folder parent = node.getParent();
        if (parent != null) {
            this.em.refresh((Object)parent);
            NodeStorage parentNodeStorage = parent.getNodeStorage(provider);
            if (parentNodeStorage == null) {
                log.warn("parent ({}) not yet stored for node {} on provider {}. parent.getStorage={}", new Object[]{parent, node, provider, parent.getStorage()});
                return null;
            }
            if (!parentNodeStorage.isSynched()) {
                log.warn("parent ({}) not synched for node {} on provider {}. synchedChange : {} changedOn {}", new Object[]{parent, node, provider, parentNodeStorage.getSynchedChange(), parent.getChangedOn()});
                return null;
            }
        }
        if ((ns = node.getNodeStorage(provider)) == null) {
            log.debug("Node {} did not have associated NodeStorage for provider {}. creating new NodeStorage object and calling nodeStorage.startSynch().", (Object)node, (Object)provider);
            ns = provider.newNodeStorage(node);
            node.getStorage().add(ns);
            ns.startSynch();
        } else {
            if (ns.isSynched()) {
                log.debug("Node {} already sinched on provider {}.  synchedChange : {} changedOn {}. skipping.", new Object[]{node, provider, ns.getSynchedChange(), node.getChangedOn()});
                return null;
            }
            if (ns.isSynching() && ns.getTimeSinceLastSynchBeat() > TimeUnit.SECONDS.toMillis(30L)) {
                log.debug("Node {} over beat threashold on adapter {}. time since last beat:{} . restarting synch", new Object[]{node, provider, ns.getTimeSinceLastSynchBeat()});
                ns.restartSynch();
            } else {
                if (ns.isSynching()) {
                    log.debug("Node {} currently synching on provider {}. skipping.", (Object)node, (Object)provider);
                    return null;
                }
                log.debug("Node {} had existing NodeStorage for provider {}. calling nodeStorage.startSynch().", (Object)node, (Object)provider);
                ns.startSynch();
            }
        }
        log.debug("initialiseRequiresNew Flushing {}", (Object)node);
        this.em.flush();
        log.debug("initialiseRequiresNew Flushed node {}", (Object)node);
        this.em.lock((Object)node, LockModeType.NONE);
        return ns;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <T extends NodeStorage> T updateNodeStorage(@NonNull T entity) {
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        try {
            log.debug("Merging {}", entity);
            entity = (NodeStorage)this.em.merge(entity);
            this.em.flush();
            log.debug("Merged {}", entity);
        }
        catch (Exception e) {
            log.warn(ValidationUtils.getConstraintValidationDetails((Throwable)e), (Throwable)e);
            throw e;
        }
        return entity;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Revision addRevisionStorage(Revision r, RevisionStorage rs) {
        Revision revision = (Revision)this.em.find(Revision.class, (Object)r.getId());
        this.em.refresh((Object)revision);
        RevisionStorage current = revision.getRevisionStorage(rs.getProvider());
        if (revision.getRevisionStorage(rs.getProvider()) != null) {
            log.error("Cannot add RevisionStorage {} as a revision storage object for provider {} already exists: {}", new Object[]{rs, rs.getProvider(), current});
            return null;
        }
        revision.getStorage().add(rs);
        this.em.flush();
        return revision;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <T extends StorageProvider> NodeStorage<T> updateNodeStorageAndAddRevisionStorage(NodeStorage<T> ns, Revision r, RevisionStorage<T> rs) {
        ns = (NodeStorage)this.em.merge(ns);
        this.addRevisionStorage(r, rs);
        return ns;
    }
}

