/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.mirror;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.util.logging.Logged;
import com.anahata.yam.domain.copy.CopyGroupProducer;
import com.anahata.yam.model.Base_;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Document_;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.Revision_;
import com.anahata.yam.model.dms.mirror.DeviceInfo;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.model.dms.mirror.MirrorLayout;
import com.anahata.yam.model.dms.mirror.MirrorType;
import com.anahata.yam.model.dms.mirror.Mirror_;
import com.anahata.yam.model.dms.mirror.NextUpload;
import com.anahata.yam.model.dms.mirror.NextUploads;
import com.anahata.yam.service.dms.YamDms;
import com.anahata.yam.service.dms.mirror.MirrorService;
import com.anahata.yam.service.dms.push.DmsEventPublisher;
import com.anahata.yam.service.tracking.NotTracked;
import com.anahata.yam.service.tracking.Tracked;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Logged
@Tracked
@Stateless
@LocalBean
public class MirrorServiceImpl
implements MirrorService {
    private static final Logger log = LoggerFactory.getLogger(MirrorServiceImpl.class);
    @Inject
    @Yam
    private EntityManager em;
    @EJB
    private UserServiceLocal userService;
    @Inject
    @YamDms
    private DmsEventPublisher eventService;
    @Inject
    private CopyGroupProducer copyGroupProducer;
    @Inject
    private ServerConfig config;

    public MirrorLayout getMirrorLayout(@NonNull DeviceInfo deviceInfo, @NonNull MirrorType type) {
        if (deviceInfo == null) {
            throw new NullPointerException("deviceInfo");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        Mirror local = this.getLocalMirror(deviceInfo, type);
        List<Mirror> shared = this.getSharedMirrors(deviceInfo, type);
        shared.remove(local);
        return new MirrorLayout(local, shared);
    }

    public List<Mirror> getSharedMirrors(DeviceInfo deviceInfo, MirrorType type) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Mirror.class);
        Root root = cq.from(Mirror.class);
        cq.select((Selection)root);
        Predicate broadcastAddress = cb.equal((Expression)root.get(Mirror_.broadcastAddress), (Object)deviceInfo.getBroadcastAddress());
        Predicate notLocal = cb.notEqual((Expression)root.get(Mirror_.type), (Object)MirrorType.LOCAL);
        Predicate active = cb.equal((Expression)root.get(Mirror_.active), (Object)true);
        cq.where(new Predicate[]{broadcastAddress, notLocal, active});
        List l = this.em.createQuery(cq).getResultList();
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.copyGroupProducer.newDefaultCopyGroup(Mirror.class), (List)l);
    }

    public Mirror getLocalMirror(DeviceInfo deviceInfo, MirrorType type) {
        Mirror ret;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Mirror.class);
        Root root = cq.from(Mirror.class);
        cq.select((Selection)root);
        Predicate macAddress = cb.equal((Expression)root.get(Mirror_.macAddress), (Object)deviceInfo.getMacAddress());
        Predicate osUserHome = cb.equal((Expression)root.get(Mirror_.osUserHome), (Object)deviceInfo.getOsUserHome());
        Predicate mirrorType = cb.equal((Expression)root.get(Mirror_.type), (Object)type);
        cq.where(new Predicate[]{macAddress, osUserHome, mirrorType});
        List l = this.em.createQuery(cq).getResultList();
        if (l.isEmpty()) {
            log.info("Creating new Mirror for logged in user: " + this.userService.getLoggedInUser());
            ret = new Mirror(this.userService.getLoggedInUser(), deviceInfo, type);
            this.em.persist((Object)ret);
        } else {
            ret = (Mirror)l.get(0);
        }
        return (Mirror)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.copyGroupProducer.newDefaultCopyGroup(Mirror.class), (Object)ret);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<String> getRecentlyAccessedRevisions(int days) {
        Date fromDate = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        String sql = "Select r.id from Revision r  WHERE r.document.accessedOn > :date  AND r.number = (SELECT MAX (r2.number) FROM Revision r2 WHERE r2.document = r.document)  AND r.synchStatus = :status ORDER BY r.document.accessedOn DESC";
        return this.em.createQuery(sql, String.class).setParameter("date", (Object)fromDate).setParameter("status", (Object)RevisionSynchStatus.UPLOADED).getResultList();
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @NotTracked(trackOnline=false)
    public List<Document> getWorkingCopies(long mirrorId) {
        Object u = this.userService.getLoggedInUser();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Document.class);
        Root r = cq.from(Document.class);
        cq.where(new Predicate[]{cb.equal((Expression)r.get(Document_.lockedBy), u), cb.equal((Expression)r.get(Document_.workingCopyMirror).get(Base_.id), (Object)mirrorId)});
        List docs = this.em.createQuery(cq).getResultList();
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.copyGroupProducer.newNode(), (List)docs);
    }

    @NotTracked
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public NextUploads getNextUploads(long mirrorId, int max, List<String> skip) {
        NextUploads ret = new NextUploads();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery count = cb.createQuery(Long.class);
        Root r = count.from(Revision.class);
        ListJoin m = r.join(Revision_.mirrors);
        ArrayList<Predicate> whereClause = new ArrayList<Predicate>();
        whereClause.add(cb.equal((Expression)m.get(Mirror_.id), (Object)mirrorId));
        whereClause.add(cb.equal((Expression)r.get(Revision_.document).get(Document_.removed), (Object)false));
        if (!skip.isEmpty()) {
            whereClause.add(r.get(Revision_.id).in(skip).not());
        }
        Predicate revPendingUpload = cb.equal((Expression)r.get(Revision_.synchStatus), (Object)RevisionSynchStatus.PENDING_UPLOAD);
        Predicate revUploading = cb.equal((Expression)r.get(Revision_.synchStatus), (Object)RevisionSynchStatus.UPLOADING);
        Date ago10Secs = DateUtils.addSeconds((Date)new Date(), (int)-10);
        Predicate uploadProgressTimestampOld = cb.lessThanOrEqualTo((Expression)r.get(Revision_.uploadProgressTimestamp), (Comparable)ago10Secs);
        Predicate staledUpload = cb.and((Expression)revUploading, (Expression)uploadProgressTimestampOld);
        Predicate pendingUploadOrStaledUpload = cb.or((Expression)revPendingUpload, (Expression)staledUpload);
        whereClause.add(pendingUploadOrStaledUpload);
        count.where(whereClause.toArray(new Predicate[0]));
        count.select((Selection)cb.count((Expression)r));
        ret.setTotalPendingUpload((Long)this.em.createQuery(count).getSingleResult());
        if (ret.getTotalPendingUpload() > 0L) {
            CriteriaQuery revs = cb.createQuery(NextUpload.class);
            revs.where(whereClause.toArray(new Predicate[0]));
            revs.distinct(true);
            revs.select((Selection)cb.construct(NextUpload.class, new Selection[]{r.get(Revision_.id), r.get(Revision_.fileName)}));
            ret.setUploads(this.em.createQuery(revs).setMaxResults(max).getResultList());
        }
        return ret;
    }

    public Revision lockRevision(@NonNull String revisionId) {
        if (revisionId == null) {
            throw new NullPointerException("revisionId");
        }
        Revision r = (Revision)this.em.find(Revision.class, (Object)revisionId, LockModeType.PESSIMISTIC_WRITE);
        Validate.notNull((Object)r, (String)"Could not find revision %s", (Object[])new Object[]{revisionId});
        return r;
    }

    private Mirror findMirror(@NonNull Long mirrorId) {
        if (mirrorId == null) {
            throw new NullPointerException("mirrorId");
        }
        Mirror m = (Mirror)this.em.find(Mirror.class, (Object)mirrorId);
        Validate.notNull((Object)m, (String)"Could not find mirror %s", (Object[])new Object[]{mirrorId});
        return m;
    }

    public boolean startUpload(String revisionId) {
        Revision r = this.lockRevision(revisionId);
        boolean success = r.startUpload();
        if (success) {
            this.eventService.nodesModified((Node[])new Document[]{r.getDocument()});
        }
        return success;
    }

    public boolean progressUpload(String revisionId, float progress) {
        Revision r = this.lockRevision(revisionId);
        boolean success = r.progressUpload(Float.valueOf(progress));
        if (success && this.config.isDmsUploadsProgressEnabled()) {
            this.eventService.nodesModified((Node[])new Document[]{r.getDocument()});
        }
        return success;
    }

    public boolean completeUpload(String revisionId, @NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        Revision r = this.lockRevision(revisionId);
        ArrayList l = new ArrayList(r.getMirrors());
        boolean success = r.completeUpload(data);
        if (success) {
            this.eventService.nodesModified(new ArrayList(r.getAllDocuments()));
        }
        this.em.flush();
        for (Mirror l1 : l) {
            log.info("After flushing complete upload: " + l1.getRevisionsPendingUpload().contains(r));
        }
        return success;
    }

    public boolean cancelUpload(String revisionId) {
        Revision r = this.lockRevision(revisionId);
        boolean success = r.cancelUpload();
        if (success) {
            this.eventService.nodesModified((Node[])new Document[]{r.getDocument()});
        }
        return success;
    }

    public Mirror save(Mirror mirror) {
        mirror = (Mirror)this.em.merge((Object)mirror);
        return (Mirror)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.copyGroupProducer.newDefaultCopyGroup(Mirror.class), (Object)mirror);
    }
}

