/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms.event.jms;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.yam.domain.copy.CopyGroupProducer;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.service.dms.push.DmsEventPublisher;
import com.anahata.yam.service.dms.pushpull.DmsEvents;
import com.anahata.yam.tech.Yam;
import com.anahata.yam.tech.push.PushProxyFactory;
import com.anahata.yam.tech.push.PushSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@LocalBean
public class PushDmsEventPublisher
implements DmsEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(PushDmsEventPublisher.class);
    @Inject
    private PushProxyFactory pushProxyFactory;
    @Inject
    private CopyGroupProducer copyGroupProducer;
    @Inject
    @Yam
    private EntityManager em;

    @Override
    public <T extends Node> void nodesAdded(T ... nodes) {
        this.nodesAdded(Arrays.asList(nodes));
    }

    @Override
    public <T extends Node> void nodesAdded(List<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.getDmsEvents(nodes).nodesAdded(this.copy(nodes));
    }

    @Override
    public <T extends Node> void nodesModified(T ... nodes) {
        this.nodesModified(Arrays.asList(nodes));
    }

    @Override
    public <T extends Node> void nodesModified(List<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.getDmsEvents(nodes).nodesModified(this.copy(nodes));
    }

    @Override
    public <T extends Node> void nodesRemoved(T ... nodes) {
        this.nodesRemoved(Arrays.asList(nodes));
    }

    @Override
    public <T extends Node> void nodesRemoved(List<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.getDmsEvents(nodes).nodesRemoved(Node.getIdsList(nodes));
    }

    @Override
    public <T extends Node> void nodeMoved(Node node, Folder oldParent) {
        this.nodesMoved(node.getParent(), Collections.singletonMap(node, oldParent));
    }

    @Override
    public <T extends Node> void nodesMoved(Folder newParent, Map<Node, Folder> oldParentAndNode) {
        if (oldParentAndNode.isEmpty()) {
            return;
        }
        HashMap<Long, Long> oldParentAndNodeIds = new HashMap<Long, Long>();
        for (Map.Entry<Node, Folder> entry : oldParentAndNode.entrySet()) {
            oldParentAndNodeIds.put(entry.getKey().getId(), entry.getValue().getId());
        }
        HashSet<Folder> allFolders = new HashSet<Folder>();
        allFolders.addAll(oldParentAndNode.values());
        allFolders.add(newParent);
        this.getDmsEventsForParents(allFolders).nodesMoved(newParent.getId().longValue(), oldParentAndNodeIds);
    }

    @Override
    public <T extends Node> void nodesTrashed(T ... nodes) {
        this.nodesTrashed(Arrays.asList(nodes));
    }

    @Override
    public <T extends Node> void nodesTrashed(List<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.getDmsEvents(nodes).nodesTrashed(Node.getIdsList(nodes));
    }

    @Override
    public <T extends Node> void nodesUntrashed(T ... nodes) {
        this.nodesUntrashed(Arrays.asList(nodes));
    }

    @Override
    public <T extends Node> void nodesUntrashed(List<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.getDmsEvents(nodes).nodeUntrashed(Node.getIdsList(nodes));
    }

    private <T extends Node> List<T> copy(List<T> nodes) {
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.copyGroupProducer.newNode(), nodes);
    }

    private <T extends Node> DmsEvents getDmsEvents(List<T> nodes) {
        Set parents = Node.getAllParents(nodes);
        return this.getDmsEventsForParents(parents);
    }

    private DmsEvents getDmsEventsForParents(Collection<Folder> parents) {
        StringBuilder selectorString = new StringBuilder();
        for (Folder folder : parents) {
            if (selectorString.length() > 0) {
                selectorString.append(", ");
            }
            selectorString.append(folder.getIdPath(true));
        }
        PushSelector selector = new PushSelector();
        selector.addSelection("PARENT", String.class, selectorString.toString().trim());
        DmsEvents events = this.pushProxyFactory.newProxy(DmsEvents.class, selector);
        return events;
    }
}

