/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.dms;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.util.jpa.eclipselink.TypedCopyGroup;
import com.anahata.util.logging.Logged;
import com.anahata.yam.domain.copy.CopyGroupProducer;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.DocumentLockedException;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.FolderId;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.NodeEvent;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.model.user.User;
import com.anahata.yam.service.dms.DmsService;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.service.dms.YamDms;
import com.anahata.yam.service.dms.push.DmsEventPublisher;
import com.anahata.yam.service.tracking.Tracked;
import com.anahata.yam.service.user.UserServiceLocal;
import com.anahata.yam.tech.Yam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.validation.Validator;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Logged
@Tracked
@Stateless
@LocalBean
public class DmsServiceImpl
implements DmsServiceLocal,
DmsService {
    private static final Logger log = LoggerFactory.getLogger(DmsServiceImpl.class);
    @Inject
    @Yam
    protected EntityManager em;
    @EJB
    private UserServiceLocal userService;
    @Inject
    @YamDms
    private DmsEventPublisher eventPublisher;
    @Inject
    private Validator validator;
    @Inject
    private CopyGroupProducer cgProducer;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Node findNode(long id) {
        Node n = (Node)this.em.find(Node.class, (Object)id);
        return (Node)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), (Object)n);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<Node> findNodes(List<Long> ids) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Long id : ids) {
            Node n = (Node)this.em.find(Node.class, (Object)id);
            ret.add(n);
        }
        return JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), ret);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Folder addFolder(long parentId, @NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        Folder parent = (Folder)this.findLocal(parentId);
        Validate.notNull((Object)parent, (String)"no folder for id %s", (Object[])new Object[]{parentId});
        Folder ret = parent.addFolder(title, this.getUser());
        this.em.flush();
        this.eventPublisher.nodesAdded((Node[])new Folder[]{ret});
        return (Folder)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), (Object)ret);
    }

    @Override
    public void addFolder(long parentId, Folder folder) {
        Folder parent = (Folder)this.findLocal(parentId);
        Validate.notNull((Object)parent, (String)"no folder for id %s", (Object[])new Object[]{parentId});
        this.addFolder(parent, folder);
    }

    @Override
    public void addFolder(Folder parent, Folder folder) {
        log.debug("addFolder {}, parent managed: {}", (Object)folder.getTitle(), (Object)this.em.contains((Object)parent));
        folder.setCreatedBy(this.getUser());
        parent.addFolder(this.getUser(), folder);
        if (!this.em.contains((Object)parent)) {
            this.em.persist((Object)folder);
        }
        this.em.flush();
        log.debug("addFolder added {} Id: ", (Object)folder.getTitle(), (Object)folder.getId());
        this.eventPublisher.nodesAdded((Node[])new Folder[]{folder});
    }

    @Override
    public void addDocument(Folder folder, Document document) {
        folder.addDocument(this.getUser(), document);
        this.em.flush();
        this.eventPublisher.nodesAdded((Node[])new Document[]{document});
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Document addDocument(Folder folder, byte[] data, String name) {
        Document ret;
        try {
            ret = folder.addDocument(data, name, this.getUser());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.em.flush();
        this.eventPublisher.nodesAdded((Node[])new Document[]{ret});
        return ret;
    }

    @Override
    public <T extends Document> Document addDocument(long folderId, long mirrorId, T document) {
        return this.addDocuments(folderId, mirrorId, Collections.singletonList(document)).get(0);
    }

    public <T extends Document> T addDocumentAndWorkingCopy(long folderId, long mirrorId, T document, String workingCopyPath) {
        return this.addDocuments(folderId, mirrorId, Collections.singletonList(document), Collections.singletonList(workingCopyPath)).get(0);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public <T extends Document> List<T> addDocuments(long folderId, long mirrorId, List<T> documents) {
        return this.addDocuments(folderId, mirrorId, documents, null);
    }

    private <T extends Document> List<T> addDocuments(long folderId, long mirrorId, List<T> documents, List<String> workingCopyPaths) {
        long ts = System.currentTimeMillis();
        log.debug("Adding {} documents to {}", (Object)documents.size(), (Object)folderId);
        Folder parent = (Folder)this.findLocal(folderId, true, true);
        List<Document> ret = new ArrayList();
        ArrayList<Document> added = new ArrayList<Document>();
        User user = this.getUser();
        for (int i = 0; i < documents.size(); ++i) {
            long tsd = System.currentTimeMillis();
            Document document = (Document)documents.get(i);
            Validate.notNull((Object)document.getHeadRevision(), (String)"Document does not contain a revision", (Object[])new Object[0]);
            Validate.isTrue((document.getRevisions().size() == 1 ? 1 : 0) != 0, (String)" Document contains more than one revision", (Object[])new Object[0]);
            Revision receivedRevision = document.getHeadRevision();
            Revision managedRevision = this.lockRevision(receivedRevision.getId());
            if (managedRevision != null) {
                log.debug("Revision already existed {} will add mirror", (Object)managedRevision);
                managedRevision.addMirror((Mirror)this.em.find(Mirror.class, (Object)mirrorId));
                this.em.flush();
                this.em.lock((Object)managedRevision, LockModeType.NONE);
                document = managedRevision.getDocument();
            } else {
                log.debug("Revision did not exist {} will create", (Object)receivedRevision);
                Mirror mirror = (Mirror)this.em.find(Mirror.class, (Object)mirrorId);
                Validate.notNull((Object)mirror, (String)("Could not find mirror " + mirrorId), (Object[])new Object[0]);
                receivedRevision.setAddedBy(this.getUser());
                parent.addDocument(this.getUser(), document, mirror);
                if (workingCopyPaths != null) {
                    String wcp = workingCopyPaths.get(i);
                    document.lock(this.getUser());
                    log.debug("document getUser() {} getLockedBy {}  ", (Object)this.getUser(), (Object)document.getLockedBy());
                    document.createWorkingCopy(this.getUser(), mirror, wcp);
                }
                added.add(document);
                this.em.flush();
            }
            ret.add(document);
            tsd = System.currentTimeMillis() - tsd;
            log.debug("addDocuments took {} ms for {}", (Object)tsd, (Object)document);
        }
        log.debug("flushing");
        long flushTs = System.currentTimeMillis();
        this.em.flush();
        log.debug("flushing took {} ms.", (Object)(System.currentTimeMillis() - flushTs));
        long tsCopy = System.currentTimeMillis();
        TypedCopyGroup cg = this.cgProducer.newNode();
        System.out.println("CopyGroup is: " + cg);
        ret = JPAUtils.copy((EntityManager)this.em, (CopyGroup)cg, ret);
        tsCopy = System.currentTimeMillis() - tsCopy;
        log.debug("Copy took {} ms.", (Object)tsCopy);
        log.debug("sending jms messages");
        long tsJms = System.currentTimeMillis();
        this.eventPublisher.nodesAdded(added);
        tsJms = System.currentTimeMillis() - tsJms;
        log.debug("Jms delivery {} ms.", (Object)tsJms);
        log.debug("addDocument took {} ms.", (Object)(System.currentTimeMillis() - ts));
        return ret;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void addRevision(Document document, @NonNull Revision revision) throws DocumentLockedException {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        this.addRevision(document, null, revision);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void addRevision(Document document, Mirror mirror, @NonNull Revision revision) throws DocumentLockedException {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        this.em.lock((Object)document, LockModeType.PESSIMISTIC_WRITE);
        if (revision.getAddedBy() == null) {
            revision.setAddedBy(this.getUser());
        }
        document.addRevision(revision, mirror);
        this.em.flush();
        this.em.lock((Object)document, LockModeType.NONE);
        this.eventPublisher.nodesModified((Node[])new Document[]{document});
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public Document addRevision(long documentId, long mirrorId, @NonNull Revision revision) throws DocumentLockedException {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        Document document = (Document)this.findLocal(documentId, true, true);
        Mirror mirror = (Mirror)this.em.find(Mirror.class, (Object)mirrorId);
        this.addRevision(document, mirror, revision);
        return (Document)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), (Object)document);
    }

    public void notes(long nodeId, @NonNull String notes) {
        if (notes == null) {
            throw new NullPointerException("notes");
        }
        Node node = this.findLocal(nodeId);
        node.setNotes(notes);
        this.em.flush();
        this.eventPublisher.nodesModified(new Node[]{node});
    }

    public void rename(long nodeId, @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Node node = this.findLocal(nodeId);
        this.rename(node, name);
    }

    @Override
    public void rename(Node node, @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        node.rename(this.getUser(), name);
        this.em.flush();
        this.eventPublisher.nodesModified(new Node[]{node});
    }

    public Document lock(long documentId) throws DocumentLockedException {
        User user = this.getUser();
        Document doc = (Document)this.findLocal(documentId, true, true);
        doc.lock(user);
        this.em.lock((Object)doc, LockModeType.NONE);
        this.eventPublisher.nodesModified((Node[])new Document[]{doc});
        return (Document)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), (Object)doc);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void touchWorkingCopy(long documentId, long mirrorId, @NonNull Date modifiedOn) {
        if (modifiedOn == null) {
            throw new NullPointerException("modifiedOn");
        }
        Mirror mirror = (Mirror)this.em.find(Mirror.class, (Object)mirrorId);
        User user = this.getUser();
        Document d = (Document)this.findLocal(documentId, true, true);
        Validate.isTrue((boolean)d.isWorkInProgress(user, mirror), (String)"Work not in progress for document %s user %s mirror %s", (Object[])new Object[]{d.getTitle(), user, mirror});
        d.setWorkingCopyModifiedOn(modifiedOn);
        this.em.flush();
        this.eventPublisher.nodesModified((Node[])new Document[]{d});
    }

    public void createWorkingCopy(String headRevisionId, long mirrorId, String workingCopyPath) throws DocumentLockedException {
        Revision r = (Revision)this.em.find(Revision.class, (Object)headRevisionId);
        Validate.notNull((Object)r, (String)"Revision not found %s", (Object[])new Object[]{headRevisionId});
        Document d = r.getDocument();
        this.em.lock((Object)d, LockModeType.PESSIMISTIC_WRITE);
        Mirror mirror = (Mirror)this.em.find(Mirror.class, (Object)mirrorId);
        d.createWorkingCopy(this.getUser(), mirror, workingCopyPath);
        this.em.flush();
        this.eventPublisher.nodesModified((Node[])new Document[]{d});
    }

    public void relocate(long documentId, String workingCopyPath, Date lastModified) throws DocumentLockedException {
    }

    public void unlock(long documentId) {
        Document doc = (Document)this.em.find(Document.class, (Object)documentId, LockModeType.PESSIMISTIC_WRITE);
        doc.unlock();
        this.em.lock((Object)doc, LockModeType.NONE);
        this.eventPublisher.nodesModified((Node[])new Document[]{doc});
    }

    @Override
    public void trash(long ... nodeIds) {
        ArrayList<Node> trashedNodes = new ArrayList<Node>();
        long[] lArray = nodeIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            Node node = this.findLocal(id);
            node.trash(this.getUser());
            trashedNodes.add(node);
        }
        this.em.flush();
        this.eventPublisher.nodesTrashed(trashedNodes);
    }

    @Override
    public void untrash(long ... nodeIds) {
        ArrayList<Node> untrashedNodes = new ArrayList<Node>();
        long[] lArray = nodeIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            Node node = this.findLocal(id);
            node.untrash(this.getUser());
            untrashedNodes.add(node);
        }
        this.em.flush();
        log.debug("Sending event for {}", untrashedNodes);
        this.eventPublisher.nodesUntrashed(untrashedNodes);
    }

    public void remove(long ... nodeIds) {
        ArrayList<Node> removedNodes = new ArrayList<Node>();
        long[] lArray = nodeIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            Node node = this.findLocal(id);
            node.remove(this.getUser());
            removedNodes.add(node);
        }
        this.em.flush();
        this.eventPublisher.nodesRemoved(removedNodes);
    }

    @Override
    public void removeLocal(long ... nodeIds) {
        this.remove(nodeIds);
    }

    public void move(long newParentId, long ... nodeIds) {
        Folder newParent = (Folder)this.findLocal(newParentId);
        Node[] nodes = new Node[nodeIds.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodes[i] = this.findLocal(nodeIds[i]);
        }
        this.move(newParent, nodes);
    }

    @Override
    public void move(Folder newParent, Node ... nodes) {
        this.move(newParent, Arrays.asList(nodes));
    }

    @Override
    public void move(Folder newParent, List<Node> nodes) {
        HashMap<Node, Folder> movedNodes = new HashMap<Node, Folder>();
        for (Node node : nodes) {
            Folder oldParent = node.getParent();
            node.move(this.getUser(), newParent);
            movedNodes.put(node, oldParent);
        }
        this.em.flush();
        this.eventPublisher.nodesMoved(newParent, movedNodes);
    }

    @Override
    public void copy(long parentId, long ... nodeIds) {
        Folder parent = (Folder)this.findLocal(parentId);
        ArrayList<Node> copies = new ArrayList<Node>();
        long[] lArray = nodeIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            Node node = this.findLocal(id);
            Node copy = node.copy(this.getUser(), parent, this.getUser());
            this.em.persist((Object)copy);
            copies.add(copy);
        }
        this.em.flush();
        this.eventPublisher.nodesAdded(copies);
    }

    @Override
    public Folder getRoot() {
        return (Folder)this.em.find(Folder.class, (Object)FolderId.ROOT.getId());
    }

    @Override
    public Folder createRoot(String name) {
        if (this.getRoot() != null) {
            throw new IllegalStateException("Root folder already exists");
        }
        Folder f = Folder.newRoot((String)name, (User)this.getUser());
        this.em.persist((Object)f);
        return f;
    }

    @Override
    public Revision findRevisionLocal(@NonNull String revisionId) {
        if (revisionId == null) {
            throw new NullPointerException("revisionId");
        }
        Revision r = (Revision)this.em.find(Revision.class, (Object)revisionId);
        return r;
    }

    @Override
    public Node findNodeLocal(long nodeId) {
        Node n = (Node)this.em.find(Node.class, (Object)nodeId);
        return n;
    }

    public Revision findRevision(@NonNull String revisionId) {
        if (revisionId == null) {
            throw new NullPointerException("revisionId");
        }
        Revision r = (Revision)this.em.find(Revision.class, (Object)revisionId);
        TypedCopyGroup cg = this.cgProducer.newRevisionNoChildren();
        return (Revision)JPAUtils.copy((EntityManager)this.em, (CopyGroup)cg, (Object)r);
    }

    private Node findLocal(long id) {
        Node node = (Node)this.em.find(Node.class, (Object)id);
        Validate.notNull((Object)node, (String)"Could not find node for id %s", (Object[])new Object[]{id});
        node = (Node)this.em.find(node.getClass(), (Object)id);
        return node;
    }

    private Node findLocal(long id, boolean lock, boolean mustExist) {
        LockModeType lockModeType;
        log.info("Trying to find node {} lock={} mustExist={}", new Object[]{id, lock, mustExist});
        Node node = (Node)this.em.find(Node.class, (Object)id);
        if (mustExist) {
            Validate.notNull((Object)node, (String)"Could not find node for id %s", (Object[])new Object[]{id});
        } else if (node == null) {
            return null;
        }
        LockModeType lockModeType2 = lockModeType = lock ? LockModeType.PESSIMISTIC_WRITE : LockModeType.NONE;
        if (lock) {
            log.debug("Trying to lock node " + node + " id=" + id);
        }
        node = (Node)this.em.find(node.getClass(), (Object)id, lockModeType);
        if (lock) {
            log.debug("Node locked " + node + " id=" + id);
        }
        return node;
    }

    private User getUser() {
        Object user = this.userService.getLoggedInUser();
        Validate.notNull(user, (String)"Could not retrieve logged in user from user service", (Object[])new Object[0]);
        return user;
    }

    private Revision lockRevision(@NonNull String revisionId) {
        if (revisionId == null) {
            throw new NullPointerException("revisionId");
        }
        log.debug("Trying to lock revision " + revisionId);
        Revision r = (Revision)this.em.find(Revision.class, (Object)revisionId, LockModeType.PESSIMISTIC_WRITE);
        if (r != null) {
            log.debug("Revision locked " + revisionId);
        }
        return r;
    }

    @Override
    public List<Node> copy(Folder parent, Node ... nodes) {
        ArrayList<Node> copies = new ArrayList<Node>();
        for (Node node : nodes) {
            Folder oldParent = node.getParent();
            Node copy = node.copy(this.getUser(), parent, this.getUser());
            this.em.persist((Object)copy);
            copies.add(copy);
        }
        this.em.flush();
        this.eventPublisher.nodesAdded(copies);
        return copies;
    }

    @Override
    public <T extends NodeEvent> T addNodeEvent(T nodeEvent) {
        if (!(nodeEvent = (NodeEvent)this.em.merge(nodeEvent)).getNode().getEvents().contains(nodeEvent)) {
            nodeEvent.getNode().getEvents().add(nodeEvent);
        }
        this.eventPublisher.nodesModified(new Node[]{nodeEvent.getNode()});
        return nodeEvent;
    }

    public Document revertToRevision(String revisionId) {
        Revision r = (Revision)this.em.find(Revision.class, (Object)revisionId);
        this.em.lock((Object)r.getDocument(), LockModeType.PESSIMISTIC_WRITE);
        r.getDocument().lock(this.getUser());
        r.getDocument().revertToRevision(r, this.getUser());
        r.getDocument().unlock();
        this.em.lock((Object)r.getDocument(), LockModeType.NONE);
        this.eventPublisher.nodesModified((Node[])new Document[]{r.getDocument()});
        return (Document)JPAUtils.copy((EntityManager)this.em, (CopyGroup)this.cgProducer.newNode(), (Object)r.getDocument());
    }

    @Override
    public void setQuota(Folder folder, Long quota) {
        folder.setQuota(quota);
        this.eventPublisher.nodesModified((Node[])new Folder[]{folder});
    }
}

