/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.jnlp.servlet;

import com.anahata.yam.jnlp.servlet.ByteArrayDownloadResponse;
import com.anahata.yam.jnlp.servlet.DownloadRequest;
import com.anahata.yam.jnlp.servlet.DownloadResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnlpFileHandler {
    private static final Logger log = LoggerFactory.getLogger(JnlpFileHandler.class);
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private ServletContext servletContext;
    private HashMap<String, DownloadResponse> cache = new HashMap();
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile("\\$\\$property.[\\S]+\\$\\$");

    public JnlpFileHandler(ServletContext servletContext) {
    }

    public synchronized DownloadResponse getJnlpFileEx(DownloadRequest dreq) throws IOException {
        DownloadResponse downloadResponse;
        String path = dreq.getPath();
        URL resource = dreq.getFile().toURI().toURL();
        Date lastModified = dreq.getFileLastModified();
        String reqUrl = HttpUtils.getRequestURL((HttpServletRequest)dreq.getHttpRequest()).toString();
        if (dreq.getQuery() != null) {
            reqUrl = reqUrl + dreq.getQuery();
        }
        if (!((downloadResponse = this.cache.get(reqUrl)) == null || dreq.getIfModifiedSince() != null && downloadResponse.getLastModified().after(dreq.getIfModifiedSince()))) {
            return downloadResponse;
        }
        String mimeType = JNLP_MIME_TYPE;
        StringBuffer jnlpFileTemplate = new StringBuffer();
        URLConnection conn = resource.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String line = br.readLine();
        if (line != null && line.startsWith("TS:")) {
            long timeStamp = this.parseTimeStamp(line.substring(3));
            if (timeStamp == 0L) {
                timeStamp = lastModified.getTime();
            }
            line = br.readLine();
        }
        while (line != null) {
            jnlpFileTemplate.append(line);
            line = br.readLine();
        }
        String jnlpFileContent = this.specializeJnlpTemplate(dreq.getHttpRequest(), path, jnlpFileTemplate.toString());
        byte[] byteContent = jnlpFileContent.getBytes("UTF-8");
        downloadResponse = new ByteArrayDownloadResponse(byteContent, mimeType, dreq.getFileLastModified());
        this.cache.put(reqUrl, downloadResponse);
        return downloadResponse;
    }

    private String specializeJnlpTemplate(HttpServletRequest request, String respath, String jnlpTemplate) {
        String urlprefix = this.getUrlPrefix(request);
        int idx = respath.lastIndexOf(47);
        String name = respath.substring(idx + 1);
        String codebase = respath.substring(0, idx + 1);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$name", name);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$hostname", request.getServerName());
        jnlpTemplate = this.substitute(jnlpTemplate, "$$codebase", urlprefix + request.getContextPath() + codebase);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$context", urlprefix + request.getContextPath());
        jnlpTemplate = this.substitute(jnlpTemplate, "$$site", urlprefix);
        jnlpTemplate = this.substituteSystemProperties(jnlpTemplate);
        return jnlpTemplate;
    }

    private String getUrlPrefix(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url.toString();
    }

    private String substitute(String target, String key, String value) {
        int start = 0;
        int idx;
        while ((idx = target.indexOf(key, start)) != -1) {
            target = target.substring(0, idx) + value + target.substring(idx + key.length());
            start = idx + value.length();
        }
        return target;
    }

    private long parseTimeStamp(String timestamp) {
        int ss;
        int mm;
        int hh;
        int DD;
        int MM;
        int YYYY;
        block10: {
            YYYY = 0;
            MM = 0;
            DD = 0;
            hh = 0;
            mm = 0;
            ss = 0;
            timestamp = timestamp.trim();
            try {
                if (this.matchPattern("####-##-## ##:##", timestamp)) {
                    YYYY = this.getIntValue(timestamp, 0, 4);
                    MM = this.getIntValue(timestamp, 5, 7);
                    DD = this.getIntValue(timestamp, 8, 10);
                    hh = this.getIntValue(timestamp, 11, 13);
                    mm = this.getIntValue(timestamp, 14, 16);
                    if (this.matchPattern(":##", timestamp = timestamp.substring(16))) {
                        ss = this.getIntValue(timestamp, 1, 3);
                        timestamp = timestamp.substring(3);
                    }
                    break block10;
                }
                if (this.matchPattern("############", timestamp)) {
                    YYYY = this.getIntValue(timestamp, 0, 4);
                    MM = this.getIntValue(timestamp, 4, 6);
                    DD = this.getIntValue(timestamp, 6, 8);
                    hh = this.getIntValue(timestamp, 8, 10);
                    mm = this.getIntValue(timestamp, 10, 12);
                    if (this.matchPattern("##", timestamp = timestamp.substring(12))) {
                        ss = this.getIntValue(timestamp, 0, 2);
                        timestamp = timestamp.substring(2);
                    }
                    break block10;
                }
                return 0L;
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        String timezone = null;
        timestamp = timestamp.trim();
        if (timestamp.equalsIgnoreCase("Z")) {
            timezone = "GMT";
        } else if (timestamp.startsWith("+") || timestamp.startsWith("-")) {
            timezone = "GMT" + timestamp;
        }
        if (timezone == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(YYYY, MM - 1, DD, hh, mm, ss);
            return cal.getTime().getTime();
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.set(YYYY, MM - 1, DD, hh, mm, ss);
        return cal.getTime().getTime();
    }

    private int getIntValue(String key, int start, int end) {
        return Integer.parseInt(key.substring(start, end));
    }

    private boolean matchPattern(String pattern, String key) {
        if (key.length() < pattern.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char format = pattern.charAt(i);
            char ch = key.charAt(i);
            if (format == '#' && Character.isDigit(ch) || format == ch) continue;
            return false;
        }
        return true;
    }

    private String substituteSystemProperties(String target) {
        Matcher matcher = SYSTEM_PROPERTY_PATTERN.matcher(target);
        while (matcher.find()) {
            String key = matcher.group();
            int startIdx = key.indexOf(".") + 1;
            String property = key.substring(startIdx);
            String value = System.getProperty(property = property.substring(0, property.length() - 2));
            if (value == null) {
                value = "";
            }
            target = this.substitute(target, key, value);
        }
        return target;
    }
}

