/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.jnlp.servlet;

import com.anahata.yam.jnlp.servlet.DownloadRequest;
import com.anahata.yam.jnlp.servlet.DownloadResponse;
import com.anahata.yam.jnlp.servlet.FileDownloadResponse;
import com.anahata.yam.jnlp.servlet.jardiff.JarDiff;
import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarHandler {
    private static final Logger log = LoggerFactory.getLogger(JarHandler.class);
    private final ServletContext servletContext;
    private HashMap<String, DownloadResponse> cache = new HashMap();

    public DownloadResponse getDownloadResponse(DownloadRequest dr) throws IOException {
        if (dr.getRequestedVersion() == null) {
            log.debug("Ignoring non versioned jar request " + dr);
            return null;
        }
        log.debug("Processing versioned jar request " + dr);
        File packGzJarFile = dr.getRequestedVersionJarPackGzFile();
        if (!packGzJarFile.exists()) {
            log.error("Could not locate " + packGzJarFile);
            return null;
        }
        boolean returnFullPackGzJar = false;
        if (dr.getRequestedVersion().equals(dr.getCurrentVersion())) {
            log.info("Request current versionId is same as current version id, returning entire jar");
            returnFullPackGzJar = true;
        } else if (dr.getCurrentVersion() == null) {
            log.info("Request current versionId is null, returning entire jar");
            returnFullPackGzJar = true;
        } else {
            File currVersionJar = dr.getCurrentVersionCacheJarFile();
            if (!currVersionJar.exists()) {
                log.info("Current version unpacked jar {} not in cache, returning entire jar {}", (Object)currVersionJar);
                returnFullPackGzJar = true;
            } else {
                log.info("Current version unpacked jar {} (size = {}) exists in cache, will create jar diff", (Object)currVersionJar, (Object)currVersionJar.length());
            }
        }
        File requestedVersionCacheJar = dr.getRequestedVersionCacheJarFile();
        if (returnFullPackGzJar) {
            if (!requestedVersionCacheJar.exists()) {
                log.info("Requested version unpacked jar not in cache, unpacking asynchronously {}", (Object)requestedVersionCacheJar);
                JarHandler.unpackAsynch(packGzJarFile, requestedVersionCacheJar);
            }
            log.info("returning entire jar {}", (Object)packGzJarFile);
            FileDownloadResponse ret = new FileDownloadResponse(packGzJarFile);
            ret.setContentEncoding("pack200-gzip");
            ret.setMimeType("application/x-java-pack200");
            ret.setVersionId(dr.getRequestedVersion());
            return ret;
        }
        File diff = dr.getDiffCacheFile();
        if (!diff.exists()) {
            if (!requestedVersionCacheJar.exists()) {
                log.info("Requested version unpacked jar not in cache, unpacking to cache {}", (Object)requestedVersionCacheJar);
                JarHandler.unpack(packGzJarFile, requestedVersionCacheJar);
            }
            log.info("JarDiff {} not in cache, creating , currentVersionSize={}, requesteVersinSize={} ", new Object[]{diff, dr.getCurrentVersionCacheJarFile().length(), requestedVersionCacheJar.length()});
            File diffTemp = File.createTempFile(diff.getName(), ".tmp");
            try (FileOutputStream fos = new FileOutputStream(diffTemp);){
                JarDiff.createPatch(dr.getCurrentVersionCacheJarFile(), requestedVersionCacheJar, fos, true);
            }
            log.info("JarDiff created in temp file size {}", (Object)diffTemp.length());
            FileUtils.deleteQuietly((File)diff);
            diffTemp.renameTo(diff);
            log.info("JarDiff (not packed) stored in cache {} size={}", (Object)diff.length());
        } else {
            log.info("JarDiff existed in cache, returning diff {} length={}", (Object)diff, (Object)diff.length());
        }
        FileDownloadResponse ret = new FileDownloadResponse(diff);
        ret.setMimeType("application/x-java-archive-diff");
        ret.setVersionId(dr.getRequestedVersion());
        return ret;
    }

    private static void unpackAsynch(File jarPackGzSource, File jarDest) {
        new Thread(() -> {
            try {
                JarHandler.unpack(jarPackGzSource, jarDest);
            }
            catch (Exception e) {
                log.error("Exception in asynchronous unpack operation");
            }
        }).start();
    }

    private static void unpack(File jarPackGzSource, File jarDest) throws IOException {
        File temp = File.createTempFile(jarDest.getName(), ".tmp");
        log.info("unpacking {} to {}", (Object)jarPackGzSource, (Object)jarDest);
        long ts = System.currentTimeMillis();
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(jarPackGzSource)));
             JarOutputStream out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));){
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)in, out);
        }
        FileUtils.deleteQuietly((File)jarDest);
        temp.renameTo(jarDest);
        ts = System.currentTimeMillis() - ts;
        log.info("unpacking {} to {} took {} ms.", new Object[]{jarPackGzSource, jarDest, ts});
    }

    private static void pack(File source, File destination) throws IOException {
        long ts = System.currentTimeMillis();
        log.debug("Packing \n\t{} size={} to \n\t{}", new Object[]{source, source.length(), destination});
        File temp = File.createTempFile(destination.getName(), ".tmp");
        try (JarFile jar = new JarFile(source, false);
             FileOutputStream out = new FileOutputStream(temp);){
            GZIPOutputStream gzipOut = new GZIPOutputStream(out){
                {
                    this.def.setLevel(9);
                }
            };
            BufferedOutputStream bos = new BufferedOutputStream(gzipOut);
            Pack200.Packer packer = Pack200.newPacker();
            packer.pack(jar, (OutputStream)bos);
            bos.flush();
            gzipOut.finish();
        }
        log.debug("pack operation to temp file finished size = {}, renaming {} to {}", new Object[]{temp.length(), temp, destination});
        FileUtils.deleteQuietly((File)destination);
        temp.renameTo(destination);
        ts = System.currentTimeMillis() - ts;
        log.debug("after renaming packed file {}, size is {} took {} ms.", new Object[]{destination, destination.length(), ts});
    }

    public static void main(String[] args) throws Exception {
        File source = new File("/tmp/com.anahata-JobTracking-app-1.1.19-SNAPSHOT.20150429.164652-local-maven-repo-to-1.1.19-SNAPSHOT.20150429.165037-local-maven-repo.jardiff.pack.gz8049565465949587518.tmp");
        File target = new File("/tmp/anahata-jws-cache/xxx.jardiff");
        JarHandler.unpack(source, target);
    }

    @ConstructorProperties(value={"servletContext"})
    public JarHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

