/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.jnlp.servlet;

import com.anahata.yam.jnlp.servlet.DownloadRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DownloadResponse {
    private static final Logger log = LoggerFactory.getLogger(DownloadResponse.class);
    protected static final String HEADER_LASTMOD = "Last-Modified";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String HEADER_JNLP_VERSION = "x-java-jnlp-version-id";
    public static final String PACK200_GZIP_ENCODING = "pack200-gzip";
    public static final String PACK200_MIME_TYPE = "application/x-java-pack200";
    protected static final String JNLP_ERROR_MIMETYPE = "application/x-java-jnlp-error";
    public static final String JARDIFF_MIMETYPE = "application/x-java-archive-diff";
    protected Date lastModified;
    protected String mimeType;
    protected long contentLength;
    protected String contentEncoding;
    protected String versionId;

    protected DownloadResponse() {
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        if (lastModified != null) {
            lastModified = new Date(lastModified.getTime() / 1000L * 1000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendResponse(DownloadRequest dr, HttpServletResponse resp) throws IOException, ServletException {
        try (InputStream is = this.getInputStream();
             ServletOutputStream os = resp.getOutputStream();){
            if (is == null) {
                log.debug("Not Found " + dr);
                resp.sendError(404);
                return;
            }
            if (dr.getIfModifiedSince() != null && !this.lastModified.after(dr.getIfModifiedSince())) {
                log.debug("Not modified " + this);
                resp.sendError(304);
                return;
            }
            if (this.lastModified != null) {
                log.debug("Last-Modified: " + this.contentLength);
                resp.setDateHeader(HEADER_LASTMOD, this.lastModified.getTime());
            }
            if (this.versionId != null) {
                log.debug("x-java-jnlp-version-id: " + this.versionId);
                resp.setHeader(HEADER_JNLP_VERSION, this.versionId);
            }
            if (this.contentLength != 0L) {
                log.debug("Content-Length: " + this.contentLength);
                resp.setContentLengthLong(this.contentLength);
            }
            if (this.contentEncoding != null) {
                log.debug("Content-Encoding: " + this.contentEncoding);
                resp.setHeader(HEADER_CONTENT_ENCODING, this.contentEncoding);
            }
            if (this.mimeType != null) {
                log.debug("Content-Type: " + this.mimeType);
                resp.setContentType(this.mimeType);
            }
            log.debug("Streaming: " + is);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        catch (Exception e) {
            log.error("Exception in sendResponse", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected abstract InputStream getInputStream() throws Exception;

    public String toString() {
        return " , lastModified=" + this.lastModified + ", mimeType=" + this.mimeType + ", contentLength=" + this.contentLength + '}';
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }
}

