/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.jnlp.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRequest {
    private static final Logger log = LoggerFactory.getLogger(DownloadRequest.class);
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private String path = null;
    private String requestedVersion = null;
    private String currentVersion = null;
    private String[] os = null;
    private String[] arch = null;
    private String[] locale = null;
    private String[] knownPlatforms = null;
    private String query = null;
    private boolean isPlatformRequest = false;
    private Date ifModifiedSince;
    private String encoding = null;
    private HttpServletRequest httpRequest = null;
    public static final String ACCEPT_ENCODING = "accept-encoding";

    public DownloadRequest(HttpServletRequest request) {
        this.httpRequest = request;
        this.path = request.getRequestURI();
        this.encoding = request.getHeader(ACCEPT_ENCODING);
        String context_path = request.getContextPath();
        if (context_path != null) {
            this.path = this.path.substring(context_path.length());
        }
        if (this.path == null) {
            this.path = request.getServletPath();
        }
        if (this.path == null) {
            this.path = "/";
        }
        this.path = this.path.trim();
        if (this.path.endsWith("/")) {
            this.path = this.path + "launch.jnlp";
        }
        this.requestedVersion = this.getParameter(request, ARG_VERSION_ID);
        this.currentVersion = this.getParameter(request, ARG_CURRENT_VERSION_ID);
        this.os = this.getParameterList(request, ARG_OS);
        this.arch = this.getParameterList(request, ARG_ARCH);
        this.locale = this.getParameterList(request, ARG_LOCALE);
        this.knownPlatforms = this.getParameterList(request, ARG_KNOWN_PLATFORMS);
        String platformVersion = this.getParameter(request, ARG_PLATFORM_VERSION_ID);
        boolean bl = this.isPlatformRequest = platformVersion != null;
        if (this.isPlatformRequest) {
            this.requestedVersion = platformVersion;
        }
        this.query = request.getQueryString();
        long date = request.getDateHeader("If-Modified-Since");
        if (date != -1L) {
            date = date / 1000L * 1000L;
            this.ifModifiedSince = new Date(date);
        }
    }

    public boolean isJar() {
        return this.path.endsWith(".jar") || this.path.endsWith(".jar.pack.gz");
    }

    public boolean isJnlp() {
        return this.path.endsWith(".jnlp");
    }

    public File getRequestedVersionJarPackGzFile() {
        String actualJarPath = this.path.substring(0, this.path.indexOf(".jar")) + "__V" + this.requestedVersion + ".jar.pack.gz";
        return new File(this.httpRequest.getServletContext().getRealPath(actualJarPath));
    }

    public File getCurrentVersionCacheJarFile() {
        return this.getCacheJarFile(this.currentVersion);
    }

    public File getRequestedVersionCacheJarFile() {
        return this.getCacheJarFile(this.requestedVersion);
    }

    public File getDiffCacheFile() {
        String diffName = this.getBaseJarFileName() + "-" + this.currentVersion + "-to-" + this.requestedVersion + ".jardiff";
        return new File(DownloadRequest.getTempDirectory(), diffName);
    }

    public String getBaseJarFileName() {
        String fileName = this.path.substring(this.path.lastIndexOf("/"), this.path.length());
        return fileName.substring(0, fileName.indexOf(".jar"));
    }

    public File getCacheJarFile(String version) {
        String actualJarFileName = this.getBaseJarFileName() + "__V" + version + ".jar";
        return new File(DownloadRequest.getTempDirectory(), actualJarFileName);
    }

    public static File getTempDirectory() {
        File temp = FileUtils.getTempDirectory();
        File jwstemp = new File(temp, "anahata-jws-cache");
        if (!jwstemp.exists()) {
            log.info("Creating temp directory " + jwstemp);
            jwstemp.mkdirs();
        }
        return jwstemp;
    }

    private String getParameter(HttpServletRequest req, String key) {
        String res = req.getParameter(key);
        return res == null ? null : res.trim();
    }

    private static String[] getStringList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int length = str.length();
        StringBuffer sb = null;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                if (sb == null) continue;
                list.add(sb.toString());
                sb = null;
                continue;
            }
            if (ch == '\\') {
                if (i + 1 >= length) continue;
                ch = str.charAt(++i);
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append(ch);
                continue;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        if (sb != null) {
            list.add(sb.toString());
        }
        if (list.size() == 0) {
            return null;
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private String[] getParameterList(HttpServletRequest req, String key) {
        String res = req.getParameter(key);
        return res == null ? null : DownloadRequest.getStringList(res.trim());
    }

    public String toString() {
        return "DownloadRequest[path=" + this.path + this.showEntry(" ifModifiedSince=", this.ifModifiedSince) + this.showEntry(" encoding=", this.encoding) + this.showEntry(" query=", this.query) + this.showEntry(" version=", this.requestedVersion) + this.showEntry(" currentVersionId=", this.currentVersion) + this.showEntry(" os=", this.os) + this.showEntry(" arch=", this.arch) + this.showEntry(" locale=", this.locale) + this.showEntry(" knownPlatforms=", this.knownPlatforms) + " isPlatformRequest=" + this.isPlatformRequest + "]";
    }

    private String showEntry(String msg, Object value) {
        if (value == null) {
            return "";
        }
        return msg + value;
    }

    private String showEntry(String msg, String value) {
        if (value == null) {
            return "";
        }
        return msg + value;
    }

    private String showEntry(String msg, String[] value) {
        if (value == null) {
            return "";
        }
        return msg + Arrays.asList(value).toString();
    }

    public boolean isSupportsGzip() {
        return this.encoding.contains("gzip");
    }

    public boolean isSupportsDeflate() {
        return this.encoding.contains("deflate");
    }

    public String getRealPath() {
        return this.getHttpRequest().getServletContext().getRealPath(this.getPath());
    }

    public boolean fileExists() {
        return this.getFile().exists();
    }

    public File getFile() {
        if (this.isJar()) {
            return this.getRequestedVersionJarPackGzFile();
        }
        log.debug("getFile() realPath" + this.getRealPath());
        return this.getRealPath() != null ? new File(this.getRealPath()) : null;
    }

    public Date getFileLastModified() {
        return this.fileExists() ? new Date(this.getFile().lastModified()) : null;
    }

    public String getFileMimeType() {
        return this.getHttpRequest().getServletContext().getMimeType(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestedVersion() {
        return this.requestedVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String[] getOs() {
        return this.os;
    }

    public String[] getArch() {
        return this.arch;
    }

    public String[] getLocale() {
        return this.locale;
    }

    public String[] getKnownPlatforms() {
        return this.knownPlatforms;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isPlatformRequest() {
        return this.isPlatformRequest;
    }

    public Date getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }
}

