/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.jnlp.servlet;

import com.anahata.yam.jnlp.servlet.DownloadRequest;
import com.anahata.yam.jnlp.servlet.DownloadResponse;
import com.anahata.yam.jnlp.servlet.FileDownloadResponse;
import com.anahata.yam.jnlp.servlet.JarHandler;
import com.anahata.yam.jnlp.servlet.JnlpFileHandler;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="AnahataJnlpDownloadServlet", urlPatterns={"/webstart/*"})
public class AnahataJnlpDownloadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AnahataJnlpDownloadServlet.class);
    JnlpFileHandler jnlpHandler;
    JarHandler jarHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.jnlpHandler = new JnlpFileHandler(config.getServletContext());
        this.jarHandler = new JarHandler(config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestStr = request.getRequestURI();
        if (request.getQueryString() != null) {
            requestStr = requestStr + "?" + request.getQueryString().trim();
        }
        log.info("Request string {}", (Object)requestStr);
        log.info("Method {}", (Object)request.getMethod());
        log.info("User-Agent {}", (Object)request.getHeader("User-Agent"));
        DownloadRequest dreq = new DownloadRequest(request);
        log.info("DownloadRequest {}", (Object)dreq);
        DownloadResponse dresp = null;
        if (dreq.isJnlp()) {
            log.debug("Request is jnlp");
            dresp = this.jnlpHandler.getJnlpFileEx(dreq);
        } else if (dreq.isJar()) {
            log.debug("Request is jar");
            dresp = this.jarHandler.getDownloadResponse(dreq);
            if (dresp == null) {
                response.sendError(404);
                return;
            }
        } else {
            log.debug("Request is file");
            dresp = new FileDownloadResponse(dreq);
        }
        log.debug("Response is " + dresp);
        dresp.sendResponse(dreq, response);
    }
}

