/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.gf.realm;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.jdbc.JDBCRealm;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamJDBCLoginModule
extends PasswordLoginModule {
    private static final Logger log = LoggerFactory.getLogger(YamJDBCLoginModule.class);
    private static final Map<String, Long> passwordFails = new HashMap<String, Long>();

    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof JDBCRealm)) {
            String msg = sm.getString("jdbclm.badrealm");
            throw new LoginException(msg);
        }
        JDBCRealm jdbcRealm = (JDBCRealm)this._currentRealm;
        if (this._username == null || this._username.length() == 0) {
            String msg = sm.getString("jdbclm.nulluser");
            throw new LoginException(msg);
        }
        StringBuilder addrUserNameId = new StringBuilder(this._username);
        try {
            HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            if (request != null) {
                addrUserNameId.append("_").append(request.getHeader("X-FORWARDED-FOR")).append("_").append(request.getRemoteAddr());
            }
        }
        catch (PolicyContextException ex) {
            _logger.info("Exception while fetching ip address of logged in user " + ex.getMessage());
        }
        Object[] grpList = jdbcRealm.authenticate(this._username, this.getPasswordChar());
        if (grpList == null) {
            Long fails = passwordFails.get(addrUserNameId.toString());
            fails = fails == null ? 1L : fails + 1L;
            passwordFails.put(addrUserNameId.toString(), fails);
            try {
                Thread.sleep(fails * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (fails > 3L) {
                log.warn("Login failed for user unique id :: {0} , failed attempts :: {1}", new Object[]{addrUserNameId, fails});
            } else {
                log.warn("Login failed for user unique id :: {0} , failed attempts :: {1}", new Object[]{addrUserNameId, fails});
            }
            String msg = sm.getString("jdbclm.loginfail", (Object)this._username);
            throw new LoginException(msg);
        }
        passwordFails.remove(addrUserNameId.toString());
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JDBC login succeeded for: " + this._username + " groups:" + Arrays.toString(grpList));
        }
        this.commitAuthentication(this._username, this.getPasswordChar(), this._currentRealm, (String[])grpList);
    }
}

