/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.domain.copy;

import com.anahata.util.jpa.eclipselink.CopyGroupFactory2;
import com.anahata.util.jpa.eclipselink.TypedCopyGroup;
import com.anahata.yam.model.dms.Document_;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.Folder_;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Node_;
import com.anahata.yam.model.dms.Revision_;
import com.anahata.yam.model.dms.TemplateDocument_;
import com.anahata.yam.model.dms.mirror.Mirror_;
import com.anahata.yam.model.media.Media_;
import com.anahata.yam.tech.Yam;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public abstract class CopyGroupProducer {
    private static final Logger log = LoggerFactory.getLogger(CopyGroupProducer.class);
    @Inject
    @Yam
    private EntityManager em;
    private CopyGroupFactory2 factory;

    @PostConstruct
    private void postConstruct() {
        this.init();
    }

    public void initDefaults(EntityManager em) {
        this.em = em;
        this.init();
    }

    private void init() {
        log.debug("init: ENTRY");
        this.factory = new CopyGroupFactory2(this.em);
        this.customizeInternal(this.factory);
        this.customize(this.factory);
        log.debug("init: EXIT");
    }

    public TypedCopyGroup newDefaultCopyGroup(Class entity) {
        TypedCopyGroup ret = this.factory.newInstance(entity);
        return ret;
    }

    public TypedCopyGroup newNode() {
        return this.newDefaultCopyGroup(Node.class);
    }

    public TypedCopyGroup newRevisionNoChildren() {
        TypedCopyGroup nodeNoChildren = this.newNodeNoChildren();
        return nodeNoChildren.getGroup((Attribute)Document_.revisions);
    }

    public TypedCopyGroup newNodeNoChildren() {
        TypedCopyGroup noChildren = this.newDefaultCopyGroup(Node.class);
        noChildren.removeAttribute(Folder_.documents.getName());
        noChildren.removeAttribute(Folder_.folders.getName());
        return noChildren;
    }

    private void customizeInternal(CopyGroupFactory2 factory) {
        factory.excludeAttribute((Attribute)Revision_.data).excludeAttribute((Attribute)Mirror_.revisionsPendingUpload).excludeAttribute((Attribute)Media_.content).excludeAttribute((Attribute)TemplateDocument_.docmosisAnalysis).excludeAttribute((Attribute)TemplateDocument_.docmosisWorkingCopy);
        TypedCopyGroup pathOnlyCopyGroup = new TypedCopyGroup(false, new Class[]{Folder.class});
        pathOnlyCopyGroup.addAttribute((Attribute)Folder_.id);
        pathOnlyCopyGroup.addAttribute((Attribute)Folder_.title);
        pathOnlyCopyGroup.addAttribute((Attribute)Folder_.quota);
        pathOnlyCopyGroup.addAttribute((Attribute)Folder_.parent, pathOnlyCopyGroup);
        factory.getGroup(Node.class).addAttribute((Attribute)Node_.parent, pathOnlyCopyGroup);
    }

    protected void customize(CopyGroupFactory2 factory) {
    }

    public String getFactoryString() {
        return this.factory.toString();
    }

    public CopyGroupFactory2 getFactory() {
        return this.factory;
    }

    protected EntityManager getEm() {
        return this.em;
    }
}

