/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.batch;

import com.anahata.yam.model.user.User;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserSessionCleanupBatch {
    private static final Logger log = LoggerFactory.getLogger(UserSessionCleanupBatch.class);
    private static final long GRACE_PERIOD = TimeUnit.SECONDS.toMillis(10L);
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    private ServerConfig config;
    @EJB
    private UserSessionCleanupBatch self;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @Schedule(minute="*", second="*/10", dayOfMonth="*", month="*", year="*", hour="*", dayOfWeek="*", persistent=false)
    public void cleanupSessions(Timer timer) {
        try {
            this.doCleanup(timer);
        }
        catch (Throwable e) {
            log.error("Exception cleaning up user sessions", e);
        }
    }

    private void doCleanup(Timer timer) {
        if (!this.config.isUserSessionCleanupBatchEnabled()) {
            log.debug("UserSessionCleanupBatch has been disabled. Cancelling timer");
            timer.cancel();
            return;
        }
        long lastRequestDue = System.currentTimeMillis() - this.config.getHeartBeatInterval();
        this.em.setProperty("javax.persistence.lock.timeout", (Object)1000);
        List staleUserIds = this.em.createQuery("Select u.id From User u WHERE u.online=true and u.lastRequestDate < :lrd").setParameter("lrd", (Object)new Date(lastRequestDue -= GRACE_PERIOD)).getResultList();
        for (Long long1 : staleUserIds) {
            this.self.logout(long1);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @Asynchronous
    public void logout(Long id) {
        log.debug("Cleaning up user session for user id={} ", (Object)id);
        this.em.setProperty("javax.persistence.lock.timeout", (Object)1000);
        User user = (User)this.em.find(User.class, (Object)id);
        user.setOnline(false);
        this.em.flush();
        log.debug("Cleaned up user session for user {} ", (Object)user.getUserName());
    }
}

