/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.batch;

import com.anahata.yam.service.tracking.TrackingServiceImpl;
import com.anahata.yam.tech.ServerConfig;
import java.util.Date;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserRequestCleanupBatch {
    private static final Logger log = LoggerFactory.getLogger(UserRequestCleanupBatch.class);
    @Inject
    private TrackingServiceImpl service;
    @Inject
    private ServerConfig config;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    @Schedule(minute="0", second="0", dayOfMonth="*", month="*", year="*", hour="0", dayOfWeek="*", persistent=false)
    public void cleanupRequests(Timer timer) {
        if (!this.config.isTrackingEnabled()) {
            timer.cancel();
            log.debug("UserRequestCleanupBatch cancelled as tracking not enable");
            return;
        }
        try {
            this.doCleanup();
        }
        catch (Throwable e) {
            log.error("Exception cleaning up user requests.", e);
        }
    }

    private void doCleanup() {
        log.debug("UserRequestCleanupBatch started.");
        Integer cleanupDays = this.config.getRequestCleanupDays();
        Date beforeDate = DateUtils.addDays((Date)new Date(), (int)(-cleanupDays.intValue()));
        this.service.cleanupRequestsOlderThan(beforeDate);
        log.debug("cleaning user request finished.");
    }
}

