/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.batch;

import com.anahata.yam.model.document.DocumentFormat;
import com.anahata.yam.model.template.Template;
import com.anahata.yam.model.template.docmosis.TemplateId;
import com.anahata.yam.model.template.model.DocumentModel;
import com.anahata.yam.model.template.model.LogonDetailsEmail;
import com.anahata.yam.model.user.User;
import com.anahata.yam.service.document.DocumentGenerationService;
import com.anahata.yam.service.template.TemplateServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DocmosisKeepAliveBatch {
    private static final Logger log = LoggerFactory.getLogger(DocmosisKeepAliveBatch.class);
    @Inject
    private DocumentGenerationService documentGeneration;
    @Inject
    @Yam
    private EntityManager em;
    @Inject
    private TemplateServiceLocal templateService;
    @Inject
    private ServerConfig sc;

    @Schedule(hour="*", minute="*", second="0", dayOfMonth="*", month="*", year="*", dayOfWeek="*", persistent=false)
    public void keepAlive(Timer t) throws Exception {
        if (!this.sc.isBatchJobsEnabled()) {
            log.debug("Cancellng timer as batch jobs not enabled.");
            t.cancel();
            return;
        }
        String templateId = TemplateId.LOGON_DETAILS.name();
        if (this.templateService.findTemplateDocument(templateId) == null && this.em.find(Template.class, (Object)templateId) == null) {
            log.debug("LogonDetailsEmail template details email not found. Cancelling DocmosisKeepAliveBatch timer");
            t.cancel();
            return;
        }
        try {
            this.doKeepAlive();
        }
        catch (Throwable e) {
            log.error("Error warming up docmosis. ", e);
        }
    }

    private void doKeepAlive() throws Exception {
        log.debug("DocmosisKeepAliveBatch - doKeepAlive");
        User user = this.newDummyUser();
        LogonDetailsEmail model = new LogonDetailsEmail(user, "www.dummyHomepage.com");
        this.documentGeneration.render((DocumentModel)model, DocumentFormat.PDF);
        log.debug("DocmosisKeepAliveBatch - doKeepAlive done");
    }

    private User newDummyUser() {
        return new User(){

            public String getFullName() {
                return "dummy-user-fullName";
            }

            public String getEmail() {
                return "dummy-user-email";
            }

            public String getMobile() {
                return "dummy-user-mobile";
            }

            public Long getContactId() {
                return null;
            }
        };
    }
}

