/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.batch;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.FolderId;
import com.anahata.yam.model.dms.databasebackup.DatabaseBackupConfig;
import com.anahata.yam.model.dms.databasebackup.DatabaseBackupDocument;
import com.anahata.yam.model.dms.databasebackup.DatabaseBackupFolder;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.model.user.User;
import com.anahata.yam.model.user.User_;
import com.anahata.yam.service.dms.DmsServiceLocal;
import com.anahata.yam.tech.ServerConfig;
import com.anahata.yam.tech.Yam;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class DatabaseBackupBatchDmsHelper {
    private static final Logger log = LoggerFactory.getLogger(DatabaseBackupBatchDmsHelper.class);
    @Inject
    private ServerConfig config;
    @Yam
    @Inject
    private EntityManager em;
    @EJB
    protected DmsServiceLocal dms;

    public void addToDmsAndCleanOld(File file) throws IOException {
        DatabaseBackupConfig backupConfig = this.config.getDatabaseBackupConfig();
        String userName = backupConfig.getDmsUserName();
        log.debug("user= {}", (Object)userName);
        User user = null;
        try {
            user = (User)JPAUtils.findByField((EntityManager)this.em, User.class, (SingularAttribute)User_.userName, (Object[])new Object[]{userName}).getSingleResult();
        }
        catch (NoResultException e) {
            throw new RuntimeException("Could not find backups user " + userName);
        }
        DatabaseBackupFolder backupFolder = null;
        List l = JPAUtils.selectAll((EntityManager)this.em, DatabaseBackupFolder.class).setMaxResults(1).getResultList();
        if (l.isEmpty()) {
            log.info("Creating Backups folder under root");
            Folder rootFolder = (Folder)this.em.find(Folder.class, (Object)FolderId.ROOT.getId());
            backupFolder = new DatabaseBackupFolder(rootFolder, "Backups", user);
            rootFolder.addFolder(user, (Folder)backupFolder);
            this.em.flush();
        } else {
            backupFolder = (DatabaseBackupFolder)l.get(0);
        }
        DatabaseBackupDocument document = new DatabaseBackupDocument(file, user);
        Integer keepDays = backupConfig.getKeepDays();
        List providers = JPAUtils.selectAll((EntityManager)this.em, StorageProvider.class).getResultList();
        log.debug("Adding backup document to dms {}", (Object)document);
        backupFolder.addDocument(user, (Document)document);
        Date expireDate = DateUtils.addDays((Date)new Date(), (int)(-keepDays.intValue()));
        List documents = backupFolder.getChildDocuments(null, true);
        for (Document doc : documents) {
            if (doc.isRemoved() && doc.isSynched(providers)) {
                log.info("hard remove document= {}", (Object)doc.getDisplayValue());
                this.em.remove((Object)doc);
                continue;
            }
            if (!doc.getCreatedOn().before(expireDate) || doc.isTrashed()) continue;
            log.info("soft remove document= {}", (Object)doc.getDisplayValue());
            doc.remove(user);
        }
    }
}

