/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.batch;

import com.anahata.util.compress.ZipUtils;
import com.anahata.util.config.AboutConfig;
import com.anahata.util.io.AnahataFileUtils;
import com.anahata.util.plaf.RuntimeUtils;
import com.anahata.yam.batch.DatabaseBackupBatchDmsHelper;
import com.anahata.yam.model.dms.databasebackup.DatabaseBackupConfig;
import com.anahata.yam.tech.ServerConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ScheduleExpression;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DatabaseBackupBatch {
    private static final Logger log = LoggerFactory.getLogger(DatabaseBackupBatch.class);
    @Inject
    private ServerConfig config;
    @Inject
    private DatabaseBackupBatchDmsHelper dmsHelper;
    @Resource
    private TimerService timerService;

    @PostConstruct
    public void scheduleDatabaseBackup() {
        log.info("postConstruct");
        if (this.config.isDatabaseBackupEnabled()) {
            log.info("backup configuration = {}", (Object)this.config.getDatabaseBackupConfig().getCronExpression());
            String[] exps = this.config.getDatabaseBackupConfig().getCronExpression().split(" ");
            ScheduleExpression expression = new ScheduleExpression().second(exps[0]).minute(exps[1]).hour(exps[2]);
            this.timerService.createCalendarTimer(expression, new TimerConfig((Serializable)((Object)("passed message " + new Date())), false));
        } else {
            log.info("Backup not enabled");
        }
    }

    @Timeout
    public void timeout(Timer timer) {
        long ts = System.currentTimeMillis();
        DatabaseBackupConfig databaseBackupConfig = this.config.getDatabaseBackupConfig();
        String time = databaseBackupConfig.getFormatter().format(System.currentTimeMillis());
        log.info("Database Backup started");
        String execCmd = databaseBackupConfig.getExecutable();
        String appBuildVersion = AboutConfig.displayVersion((String)this.config.getAppVersion()) + "_b" + this.config.getBuildNumber();
        String fileName = databaseBackupConfig.getFileName() + "_" + appBuildVersion + "_" + time;
        File location = databaseBackupConfig.getLocation();
        Integer keepDays = databaseBackupConfig.getKeepDays();
        try {
            InputStream in = RuntimeUtils.execCmd((String)execCmd);
            File zipFile = ZipUtils.compressFile((InputStream)in, (File)location, (String)fileName, (String)".sql");
            Date now = new Date();
            Date expireDate = DateUtils.addDays((Date)now, (int)(-keepDays.intValue()));
            AnahataFileUtils.deleteFilesOlderThan((File)location, (Date)expireDate);
            if (databaseBackupConfig.getDmsUserName() != null) {
                this.dmsHelper.addToDmsAndCleanOld(zipFile);
            }
        }
        catch (IOException ex) {
            log.error("Exception thrown while taking database backup at", (Throwable)ex);
        }
        log.info("Database Backup completed successfully in {} ms.", (Object)(System.currentTimeMillis() - ts));
    }
}

