/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.web.remoteinfo;

import com.anahata.util.web.remoteinfo.RemoteInfo;
import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Dependent
@WebFilter(filterName="RemoteInfoFilter", urlPatterns={"/*"})
public class RemoteInfoFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RemoteInfoFilter.class);
    @Inject
    private RemoteInfo remoteInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.remoteInfo.populate((HttpServletRequest)request);
        MDC.put((String)"user", (String)this.remoteInfo.getRemoteUser());
        MDC.put((String)"remoteHost", (String)this.remoteInfo.getRemoteHost());
        MDC.put((String)"remoteAddress", (String)this.remoteInfo.getRemoteAddress());
        log.trace("calling doFilter, remoteInfo: {}", (Object)this.remoteInfo);
        try {
            chain.doFilter(request, response);
        }
        finally {
            MDC.remove((String)"remoteUser");
            MDC.remove((String)"remoteHost");
            MDC.remove((String)"remoteAddress");
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }
}

