/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.web.remoteinfo;

import com.anahata.util.lang.Nvl;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Enumeration;
import javax.enterprise.context.RequestScoped;
import javax.servlet.http.HttpServletRequest;

@RequestScoped
public class RemoteInfo
implements Serializable {
    private String remoteAddress;
    private String remoteHost;
    private String remoteUser;
    private String remoteInstanceUID;
    private HttpServletRequest req;

    void populate(HttpServletRequest req) {
        this.req = req;
        this.remoteAddress = RemoteInfo.getRemoteAddress(req);
        this.remoteHost = req.getRemoteHost();
        this.remoteUser = req.getRemoteUser();
        this.remoteInstanceUID = req.getHeader("-x-anahata-application-instance");
    }

    private static String getRemoteAddress(HttpServletRequest req) {
        Enumeration it = req.getHeaderNames();
        while (it.hasMoreElements()) {
            String headerName = Nvl.nvl((String)((String)it.nextElement()).toLowerCase());
            if (!headerName.contains("forwarded-for")) continue;
            return req.getHeader(headerName).split("\\s*,\\s*", 2)[0];
        }
        return req.getRemoteAddr();
    }

    public String toString() {
        return "RemoteInfo{remoteAddress=" + this.remoteAddress + ", remoteHost=" + this.remoteHost + ", remoteUser=" + this.remoteUser + " remote instance id = " + this.remoteInstanceUID;
    }

    public String getRequestURL() {
        StringBuilder url = new StringBuilder();
        String scheme = this.req.getScheme();
        int port = this.req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(this.req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(this.req.getServerPort());
        }
        url.append(this.req.getContextPath());
        return url.toString();
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRemoteInstanceUID() {
        return this.remoteInstanceUID;
    }

    public HttpServletRequest getReq() {
        return this.req;
    }

    public RemoteInfo() {
    }

    @ConstructorProperties(value={"remoteAddress", "remoteHost", "remoteUser", "remoteInstanceUID", "req"})
    public RemoteInfo(String remoteAddress, String remoteHost, String remoteUser, String remoteInstanceUID, HttpServletRequest req) {
        this.remoteAddress = remoteAddress;
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
        this.remoteInstanceUID = remoteInstanceUID;
        this.req = req;
    }
}

