/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.logging.Logged;
import com.anahata.util.logging.Mdc;
import com.anahata.util.validation.ValidationUtils;
import java.io.Serializable;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Logged
@Interceptor
public class LoggingInterceptor
implements Serializable {
    @AroundInvoke
    public Object log(InvocationContext invocationContext) throws Exception {
        Class<?> targetClass = invocationContext.getTarget().getClass();
        Mdc mdc = targetClass.getAnnotation(Mdc.class);
        if (mdc != null) {
            MDC.put((String)mdc.key(), (String)mdc.value());
        } else if (invocationContext.getMethod() != null && (mdc = invocationContext.getMethod().getAnnotation(Mdc.class)) != null) {
            MDC.put((String)mdc.key(), (String)mdc.value());
        }
        Logger log = LoggerFactory.getLogger(targetClass);
        try {
            Object[] params = invocationContext.getParameters();
            log.trace("Entering {} params = {}", (Object)invocationContext.getMethod(), params != null && params.length > 20 ? params.toString() : params);
            long ts = System.currentTimeMillis();
            Object ret = invocationContext.proceed();
            ts = System.currentTimeMillis() - ts;
            log.trace("Exiting {}, took={} ms. ret={}", new Object[]{invocationContext.getMethod(), ts, ret});
            Object object = ret;
            return object;
        }
        catch (Throwable t) {
            String details = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error("@Logged Exception in  " + invocationContext.getMethod() + (details != null ? " details: \n" + details : ""), t);
            throw t;
        }
        finally {
            if (mdc != null) {
                MDC.clear();
            }
        }
    }
}

