/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.v1_5_19;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.yam.db.helper.YamDmsMigrator;
import com.anahata.yam.db.jpa.AbstractMigrator;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.FolderId;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.template.Template;
import com.anahata.yam.model.user.User;
import java.io.IOException;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsTemplateMigrator_v1_5_19
extends AbstractMigrator {
    private static final Logger log = LoggerFactory.getLogger(DmsTemplateMigrator_v1_5_19.class);
    private static final String DOT_ODT = ".odt";

    public DmsTemplateMigrator_v1_5_19() {
        super(new String[0]);
    }

    @Override
    public void migrate() throws Exception {
        log.info("migrating templates to dms");
        this.begin();
        User admin = (User)JPAUtils.selectAll((EntityManager)this.targetEm, User.class).getResultList().get(0);
        Folder templateFolder = new Folder(Long.valueOf(FolderId.TEMPLATES.getId()));
        templateFolder.setParent(YamDmsMigrator.getOrCreateRoot(this.targetEm, admin));
        templateFolder.setTitle("Templates");
        templateFolder.setCreatedBy(admin);
        this.persist(templateFolder);
        List templates = JPAUtils.selectAll((EntityManager)this.targetEm, Template.class).getResultList();
        for (Template template : templates) {
            log.debug("template= {}", (Object)template.getName());
            this.persist(DmsTemplateMigrator_v1_5_19.templateToDocument(templateFolder, template, admin));
        }
        this.commit();
    }

    public static Document templateToDocument(@NonNull Folder parentFolder, @NonNull Template template, @NonNull User user) throws IOException {
        if (parentFolder == null) {
            throw new NullPointerException("parentFolder");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (user == null) {
            throw new NullPointerException("user");
        }
        TemplateDocument document = new TemplateDocument(new Revision(template.getContent(), template.getName() + DOT_ODT, user));
        document.setTemplateId(template.getId());
        parentFolder.disableSecurityPolicy();
        parentFolder.addDocument(user, (Document)document);
        return document;
    }

    public static void main(String[] args) throws Exception {
        new DmsTemplateMigrator_v1_5_19().migrate();
    }
}

