/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmFactory {
    private static final Logger log = LoggerFactory.getLogger(EmFactory.class);
    private static final EmFactory INSTANCE = new EmFactory();
    private EntityManagerFactory sourceEmf;
    private final EntityManagerFactory targetEmf;

    private EmFactory() {
        log.debug("Creating source emf");
        try {
            this.sourceEmf = Persistence.createEntityManagerFactory((String)"source-PU");
        }
        catch (Exception ex) {
            log.warn("source-PU does not exist");
            this.sourceEmf = null;
        }
        log.debug("Creating target emf");
        this.targetEmf = Persistence.createEntityManagerFactory((String)"target-PU");
        log.debug("Completed initialising");
    }

    public static EntityManager newSource() {
        EntityManager ret = null;
        if (EmFactory.INSTANCE.sourceEmf != null) {
            ret = EmFactory.INSTANCE.sourceEmf.createEntityManager();
        }
        return ret;
    }

    public static EntityManager newTarget() {
        return EmFactory.INSTANCE.targetEmf.createEntityManager();
    }

    public static void close() {
        if (EmFactory.INSTANCE.sourceEmf != null) {
            EmFactory.INSTANCE.sourceEmf.close();
        }
        EmFactory.INSTANCE.targetEmf.close();
    }
}

