/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.jpa;

import com.anahata.util.cdi.Cdi;
import com.anahata.yam.db.LiquibaseMigrator;
import com.anahata.yam.db.jpa.AbstractMigrator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReleaseMigrator
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(AbstractReleaseMigrator.class);

    public String getConfirmationMessage() {
        return this.getClass().getPackage().getName() + " completed";
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor ra) {
    }

    public ValidationErrors validate(Database dtbs) {
        return null;
    }

    public abstract void listMigrators(List<Class<? extends AbstractMigrator>> var1);

    public void execute(Database database) throws CustomChangeException {
        log.debug("{} begins", (Object)this.getClass().getName());
        Thread.currentThread().setContextClassLoader(LiquibaseMigrator.class.getClassLoader());
        ArrayList<Class<? extends AbstractMigrator>> migrators = new ArrayList<Class<? extends AbstractMigrator>>();
        this.listMigrators(migrators);
        try {
            for (Class clazz : migrators) {
                log.debug("{} begins", (Object)clazz.getName());
                ((AbstractMigrator)Cdi.get((Class)clazz, (Annotation[])new Annotation[0])).migrate();
                log.debug("{} ends", (Object)clazz.getName());
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            throw new CustomChangeException((Throwable)e);
        }
        log.debug("{} ends", (Object)this.getClass().getName());
    }
}

