/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.jpa;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.logging.slf4j.ConstraintLogger;
import com.anahata.util.props.StructuredProperties;
import com.anahata.yam.db.jpa.EmFactory;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMigrator {
    private static final Logger log = LoggerFactory.getLogger(AbstractMigrator.class);
    protected final EntityManager sourceEm = EmFactory.newSource();
    protected final EntityManager targetEm = EmFactory.newTarget();
    protected StructuredProperties properties;
    private final EntityTransaction targetTx = this.targetEm.getTransaction();

    protected AbstractMigrator(String ... prefixes) {
        try {
            ApplicationPropertiesFactory apf = (ApplicationPropertiesFactory)Cdi.get(ApplicationPropertiesFactory.class, (Annotation[])new Annotation[0]);
            this.properties = new StructuredProperties(apf.getAppProperties(), prefixes);
        }
        catch (Exception e) {
            log.debug("Application Properties not loaded", (Throwable)e);
        }
    }

    public final void run() throws Exception {
        try {
            this.clean();
            this.migrate();
        }
        catch (Exception t) {
            ConstraintLogger.logConstraints((Logger)log, (Throwable)t);
            throw t;
        }
    }

    public final void begin() {
        this.targetTx.begin();
    }

    public final void commit() {
        this.targetTx.commit();
    }

    public final void rollback() {
        this.targetTx.rollback();
    }

    public final void persist(Object obj) {
        this.targetEm.persist(obj);
    }

    public final <T> T merge(T t) {
        return (T)this.targetEm.merge(t);
    }

    public final void flush() {
        this.targetEm.flush();
    }

    public final <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.targetEm.find(entityClass, primaryKey);
    }

    public final <T> T find(Class<T> entityClass, Enum primaryKey) {
        return (T)this.targetEm.find(entityClass, (Object)primaryKey.name());
    }

    public final <T> T querySingle(String query, Class<T> resultClass) {
        return (T)this.targetEm.createQuery(query, resultClass).getSingleResult();
    }

    public final <T> List<T> query(String query, Class<T> resultClass) {
        return this.targetEm.createQuery(query, resultClass).getResultList();
    }

    public final int update(String query) {
        return this.targetEm.createQuery(query).executeUpdate();
    }

    public final int truncate(Class entity) {
        return this.targetEm.createQuery("delete from " + entity.getSimpleName()).executeUpdate();
    }

    public void clean() throws Exception {
    }

    public abstract void migrate() throws Exception;

    public StructuredProperties getProperties() {
        return this.properties;
    }
}

