/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.helper;

import com.anahata.util.lang.ResourceUtils;
import com.anahata.yam.db.helper.AbstractTemplateMigrator;
import com.anahata.yam.model.template.Template;
import com.anahata.yam.model.template.definitions.TemplateDefinition;
import com.docmosis.SystemManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamTemplateMigrator
extends AbstractTemplateMigrator {
    private static final Logger log = LoggerFactory.getLogger(YamTemplateMigrator.class);

    @Override
    public void migrate(@NonNull EntityManager em, @NonNull List<TemplateDefinition> appTemplateDefinitions, Class resourceLoader) throws Exception {
        if (em == null) {
            throw new NullPointerException("em");
        }
        if (appTemplateDefinitions == null) {
            throw new NullPointerException("appTemplateDefinitions");
        }
        ArrayList<Callable<Template>> tasks = new ArrayList<Callable<Template>>();
        for (TemplateDefinition td : appTemplateDefinitions) {
            String location = "/templates/" + td.getFileName();
            URL u = resourceLoader != null ? resourceLoader.getResource(location) : ResourceUtils.getResource((String)location);
            if (u == null) {
                if (this.yamTemplates.contains(td)) {
                    log.warn("Could not find yam template: " + location + ". Migration will continue ");
                    continue;
                }
                log.error("Could not find app template: " + location + ". Migration halted");
                throw new RuntimeException("Could not find app template: " + location + " using ResourceUtils. Migration halted");
            }
            tasks.add(() -> {
                File f = new File(u.toURI());
                Template t = new Template();
                t.setType(td.getType());
                t.setId(td.getId());
                t.setName(td.getName());
                t.setContent(f);
                log.info("calling template.checkState(): {} ", (Object)t.getName());
                t.checkState();
                log.info("Inserting template: {} ", (Object)t.getName());
                return t;
            });
        }
        log.debug("Migrating {} templates in parallel", (Object)tasks.size());
        List list = Executors.newFixedThreadPool(3).invokeAll(tasks);
        for (Future future : list) {
            em.persist(future.get());
        }
    }

    static {
        SystemManager.initialise();
    }
}

