/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.helper;

import com.anahata.util.jpa.JPAUtils;
import com.anahata.util.lang.ResourceUtils;
import com.anahata.yam.db.helper.AbstractTemplateMigrator;
import com.anahata.yam.db.helper.YamDmsMigrator;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.FolderId;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.dms.TemplateDocument_;
import com.anahata.yam.model.template.definitions.TemplateDefinition;
import com.anahata.yam.model.user.User;
import com.docmosis.SystemManager;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.SingularAttribute;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamDmsTemplateMigrator
extends AbstractTemplateMigrator {
    private static final Logger log = LoggerFactory.getLogger(YamDmsTemplateMigrator.class);

    @Override
    public void migrate(@NonNull EntityManager em, @NonNull List<TemplateDefinition> appTemplateDefinitions, Class resourceLoader) throws Exception {
        if (em == null) {
            throw new NullPointerException("em");
        }
        if (appTemplateDefinitions == null) {
            throw new NullPointerException("appTemplateDefinitions");
        }
        em.flush();
        User user = (User)JPAUtils.selectAll((EntityManager)em, User.class).setMaxResults(1).getSingleResult();
        log.info("Migrating templates as user {}", (Object)user.getUserName());
        em.flush();
        Folder templateFolder = (Folder)em.find(Folder.class, (Object)FolderId.TEMPLATES.getId());
        if (templateFolder == null) {
            log.info("Templates folder didn't exist, creating a new one");
            templateFolder = new Folder(Long.valueOf(FolderId.TEMPLATES.getId()));
            templateFolder.setParent(YamDmsMigrator.getOrCreateRoot(em, user));
            templateFolder.setTitle("Templates");
            templateFolder.setCreatedBy(user);
            em.persist((Object)templateFolder);
            em.flush();
            log.info("Templates folder created {}", (Object)templateFolder);
        } else {
            log.info("Templates folder existed {}", (Object)templateFolder);
        }
        this.migrate(em, templateFolder, appTemplateDefinitions, "/templates/", resourceLoader);
    }

    public void migrate(@NonNull EntityManager em, @NonNull Folder parentFolder, @NonNull List<TemplateDefinition> appTemplateDefinitions, String path, Class resourceLoader) throws Exception {
        if (em == null) {
            throw new NullPointerException("em");
        }
        if (parentFolder == null) {
            throw new NullPointerException("parentFolder");
        }
        if (appTemplateDefinitions == null) {
            throw new NullPointerException("appTemplateDefinitions");
        }
        User user = (User)JPAUtils.selectAll((EntityManager)em, User.class).setMaxResults(1).getSingleResult();
        for (TemplateDefinition td : appTemplateDefinitions) {
            log.info("Processing Template Definition " + td.getName());
            em.flush();
            String location = path + td.getFileName();
            URL u = resourceLoader != null ? resourceLoader.getResource(location) : ResourceUtils.getResource((String)location);
            if (u == null) {
                if (this.yamTemplates.contains(td)) {
                    log.warn("Could not find yam template: " + location + ". Migration will continue ");
                    continue;
                }
                log.error("Could not find app template: " + location + ". Migration halted");
                throw new RuntimeException("Could not find app template: " + location + " using ResourceUtils. Migration halted");
            }
            File f = new File(u.toURI());
            em.flush();
            Revision r = new Revision(FileUtils.readFileToByteArray((File)f), f.getName(), user);
            TemplateDocument doc = null;
            em.flush();
            List list = JPAUtils.findByField((EntityManager)em, TemplateDocument.class, (SingularAttribute)TemplateDocument_.templateId, (Object[])new Object[]{td.getId()}).getResultList();
            if (list.size() > 1) {
                throw new IllegalStateException("More than one template document found for id: " + td.getId());
            }
            if (list.isEmpty()) {
                doc = new TemplateDocument(r);
                doc.setParent(parentFolder);
                doc.setTemplateId(td.getId());
                log.info("Creating new template document: {}", (Object)doc);
                em.persist((Object)doc);
            } else {
                doc = (TemplateDocument)list.get(0);
                log.info("Adding new revision to template: {}", (Object)td.getName());
                doc.addRevision(r);
            }
            log.info("flushing for {}", (Object)td.getId());
            em.flush();
            log.info("flushed");
        }
    }

    static {
        if (!SystemManager.isInitialized()) {
            SystemManager.initialise();
        }
    }
}

