/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.db.helper;

import com.anahata.yam.model.template.TemplateType;
import com.anahata.yam.model.template.definitions.TemplateDefinition;
import com.anahata.yam.model.template.docmosis.TemplateId;
import com.docmosis.SystemManager;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateMigrator {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplateMigrator.class);
    List<TemplateDefinition> yamTemplates = new ArrayList<TemplateDefinition>();

    public AbstractTemplateMigrator() {
        this.yamTemplates.add(new TemplateDefinition(TemplateId.LOGON_DETAILS.name(), "Login Details Email", "LogonDetailsEmail.odt", TemplateType.CONTENT));
        this.yamTemplates.add(new TemplateDefinition(TemplateId.STANDARD_EMAIL.name(), "Standard Email Header / Footer", "StandardEmail.odt", TemplateType.WRAPPER));
        this.yamTemplates.add(new TemplateDefinition(TemplateId.STANDARD_DOCUMENT.name(), "Standard Document (PDF) Header / Footer", "StandardDocument.odt", TemplateType.WRAPPER));
        this.yamTemplates.add(new TemplateDefinition(TemplateId.LANDSCAPE_STANDARD_DOCUMENT.name(), "Landscape Standard Document (PDF) Header / Footer", "LandscapeStandardDocument.odt", TemplateType.WRAPPER));
    }

    public void migrateYamTemplates(EntityManager em) throws Exception {
        this.migrate(em, this.yamTemplates);
    }

    public void migrateYamTemplates(EntityManager em, Class resourceLoader) throws Exception {
        this.migrate(em, this.yamTemplates, resourceLoader);
    }

    public void migrateAll(EntityManager em, List<TemplateDefinition> appTemplateDefinitions) throws Exception {
        ArrayList<TemplateDefinition> all = new ArrayList<TemplateDefinition>(this.yamTemplates);
        all.addAll(appTemplateDefinitions);
        this.migrate(em, all);
    }

    public void migrate(EntityManager em, List<TemplateDefinition> appTemplateDefinitions) throws Exception {
        this.migrate(em, appTemplateDefinitions, null);
    }

    public abstract void migrate(@NonNull EntityManager var1, @NonNull List<TemplateDefinition> var2, Class var3) throws Exception;

    static {
        SystemManager.initialise();
    }
}

