/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.util.search;

import com.anahata.util.lang.AnahataNumberUtils;
import com.anahata.yam.model.search.FullTextCriteria;
import com.anahata.yam.model.search.SearchToken;
import com.anahata.yam.service.search.PojoSearch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSearchUtils {
    private static final Logger log = LoggerFactory.getLogger(JpaSearchUtils.class);

    public static List<Predicate> buildFullTextPredicates(CriteriaBuilder cb, From from, List<SearchToken> tokens, boolean recurseJoins) {
        Validate.notNull((Object)cb, (String)"cb is required", (Object[])new Object[0]);
        Validate.notNull((Object)from, (String)"from is required", (Object[])new Object[0]);
        Validate.notNull(tokens, (String)"tokens is required", (Object[])new Object[0]);
        Validate.isTrue((tokens.size() > 0 ? 1 : 0) != 0, (String)"tokens must contain at least one token ", (Object[])new Object[0]);
        ArrayList<Predicate> ret = new ArrayList<Predicate>();
        Bindable model = from.getModel();
        EntityType entityType = null;
        if (model instanceof EntityType) {
            entityType = (EntityType)model;
        } else if (model instanceof PluralAttribute) {
            PluralAttribute la = (PluralAttribute)model;
            if (la.getElementType() instanceof ManagedType) {
                entityType = (ManagedType)la.getElementType();
            } else {
                log.warn("Could not determine ManagedType for PluralAttribute from model: " + from.getModel());
            }
        } else if (model instanceof SingularAttribute) {
            SingularAttribute sa = (SingularAttribute)model;
            entityType = (ManagedType)sa.getType();
        } else {
            log.warn("Could not determine ManagedType from model: " + from.getModel());
        }
        if (entityType != null) {
            for (Attribute att : entityType.getAttributes()) {
                JpaSearchUtils.addPredicates(cb, (Path)from, att, tokens, ret);
            }
            if (recurseJoins) {
                for (Object o : from.getJoins()) {
                    Join join = (Join)o;
                    if (join.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) continue;
                    ret.addAll(JpaSearchUtils.buildFullTextPredicates(cb, (From)join, tokens, true));
                }
            }
        }
        return ret;
    }

    private static void addPredicates(CriteriaBuilder cb, Path path, Attribute att, List<SearchToken> tokens, List<Predicate> buffer) {
        if (att instanceof SingularAttribute) {
            SingularAttribute sa = (SingularAttribute)att;
            if (sa.isVersion()) {
                return;
            }
            Type.PersistenceType persistenceType = sa.getType().getPersistenceType();
            if (PojoSearch.isSearchableType((Class)sa.getJavaType()) && (persistenceType == Type.PersistenceType.BASIC || persistenceType == Type.PersistenceType.EMBEDDABLE)) {
                for (SearchToken token : tokens) {
                    if (sa.getType() instanceof EmbeddableType) {
                        EmbeddableType et = (EmbeddableType)sa.getType();
                        for (Attribute embeddedAtt : et.getAttributes()) {
                            JpaSearchUtils.addPredicates(cb, path.get(sa), embeddedAtt, tokens, buffer);
                        }
                        continue;
                    }
                    String tokenValue = token.getToken();
                    if (Number.class.isAssignableFrom(att.getJavaType())) {
                        if (!AnahataNumberUtils.isAssignableToNumber((Class)att.getJavaType(), (String)tokenValue)) continue;
                        buffer.add(cb.equal((Expression)path.get(sa), (Object)tokenValue));
                        continue;
                    }
                    buffer.add(cb.like(cb.lower((Expression)path.get(sa)), "%" + tokenValue + "%"));
                }
            }
        }
    }

    public static Predicate makeFullTextPredicate(CriteriaBuilder cb, From from, FullTextCriteria criteria) {
        Validate.notNull((Object)cb, (String)"cb is required", (Object[])new Object[0]);
        Validate.notNull((Object)from, (String)"from is required", (Object[])new Object[0]);
        Validate.notNull((Object)criteria, (String)"from is required", (Object[])new Object[0]);
        if (criteria.isMatchAllTokens() && criteria.getSearchTokens().getPrimalTokens().size() > 1) {
            ArrayList<Predicate> andsPredicate = new ArrayList<Predicate>();
            for (SearchToken token : criteria.getSearchTokens().getPrimalTokens()) {
                List<Predicate> predicates = JpaSearchUtils.buildFullTextPredicates(cb, from, Collections.singletonList(token), criteria.isExpandSearch());
                Predicate orsPredicate = cb.or(predicates.toArray(new Predicate[predicates.size()]));
                andsPredicate.add(orsPredicate);
            }
            return cb.and(andsPredicate.toArray(new Predicate[andsPredicate.size()]));
        }
        List<Predicate> orsPredicate = JpaSearchUtils.buildFullTextPredicates(cb, from, criteria.getSearchTokens().getPrimalTokens(), criteria.isExpandSearch());
        return cb.or(orsPredicate.toArray(new Predicate[orsPredicate.size()]));
    }

    private JpaSearchUtils() {
    }
}

