/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech.pushpull;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ClassMetadataSelector {
    CLASS,
    METHOD;

    private static final Logger log;

    public static String create(Class c, Method ... methods) {
        StringBuilder sb = new StringBuilder();
        ClassMetadataSelector.appendEquals(sb, CLASS, c.getName());
        if (methods.length > 0) {
            sb.append(" AND (");
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (i > 0) {
                    sb.append(" OR ");
                }
                ClassMetadataSelector.appendEquals(sb, METHOD, method.toString());
            }
            sb.append(" )");
        }
        String ret = sb.toString();
        log.debug("Pull selector created: {}", (Object)ret);
        return ret;
    }

    private static void appendEquals(StringBuilder sb, Enum e, String value) {
        sb.append(e.name()).append(" = '").append(value).append("'");
    }

    static {
        log = LoggerFactory.getLogger(ClassMetadataSelector.class);
    }
}

