/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.tech;

import com.anahata.util.application.JWSUtils;
import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.env.ApplicationEnvironment;
import com.anahata.util.props.PropertiesUtils;
import java.io.Serializable;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class YamPropertiesFactory
implements ApplicationPropertiesFactory,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(YamPropertiesFactory.class);
    private static final String JVM_PARAM_ENVIRONMENT = "yam.environment";
    private Properties appProperties;

    @PostConstruct
    void postConstruct() {
        ApplicationEnvironment environment;
        String envProperty = JWSUtils.getSystemProperty((String)JVM_PARAM_ENVIRONMENT);
        if (envProperty == null) {
            environment = ApplicationEnvironment.LOCAL;
            log.info("JVM property yam.environment was not be set, defaulting to: " + ApplicationEnvironment.LOCAL);
        } else {
            environment = ApplicationEnvironment.valueOf((String)envProperty);
        }
        this.appProperties = new Properties();
        this.appProperties.put("yam.application.environment", environment.name());
        PropertiesUtils.loadAppProps((Properties)this.appProperties, (ApplicationEnvironment)environment);
        PropertiesUtils.setSystemProperties((Properties)this.appProperties);
    }

    public Properties getAppProperties() {
        return this.appProperties;
    }
}

