/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.location;

import com.anahata.util.xml.XMLUtils;
import com.anahata.yam.model.location.Locality;
import com.anahata.yam.util.config.CoreConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ApplicationScoped
public class AusPostPostcodeService {
    private static final Logger log = LoggerFactory.getLogger(AusPostPostcodeService.class);
    @Inject
    private CoreConfig config;
    private static String AUTH_KEY_HEADER_NAME = "AUTH-KEY";
    private static String URL = "http://auspost.com.au/api/postcode/search.xml?q=";
    private static final HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private String authKey;

    public AusPostPostcodeService(String authKey) {
        this.authKey = authKey;
    }

    @PostConstruct
    private void init() {
        this.authKey = this.config.getAusPostApiKey();
        Validate.notNull((Object)this.authKey, (String)"AusPost API key not found", (Object[])new Object[0]);
    }

    public List<Locality> lookupLocality(String locality, String state) {
        Validate.notNull((Object)locality, (String)"locality is required", (Object[])new Object[0]);
        Validate.isTrue((locality.trim().length() >= 3 ? 1 : 0) != 0, (String)"locality must be at least 3 characters long", (Object[])new Object[0]);
        return this.lookupImpl(locality.trim(), state);
    }

    public List<Locality> lookupPostcode(String postcode, String state) {
        Validate.notNull((Object)postcode, (String)"postcode is required", (Object[])new Object[0]);
        Validate.isTrue((postcode.length() == 4 ? 1 : 0) != 0, (String)"postcode should be 4 digits", (Object[])new Object[0]);
        for (char c : postcode.toCharArray()) {
            Validate.isTrue((boolean)Character.isDigit(c), (String)"postcode should be 4 digits", (Object[])new Object[0]);
        }
        return this.lookupImpl(postcode, state);
    }

    private List<Locality> lookupImpl(String q, String state) {
        GetMethod method = null;
        try {
            StringBuilder sb = new StringBuilder(URL);
            sb.append(URLEncoder.encode(q, "UTF-8"));
            if (state != null) {
                sb.append("&state=");
                sb.append(state);
            }
            sb.append("&excludePostBoxFlag=");
            sb.append("true");
            method = new GetMethod(sb.toString());
            method.setRequestHeader(AUTH_KEY_HEADER_NAME, this.authKey);
            client.executeMethod((HttpMethod)method);
            Document d = XMLUtils.DOMParseXML((InputStream)method.getResponseBodyAsStream());
            NodeList localities = d.getChildNodes().item(0).getChildNodes();
            ArrayList<Locality> ret = new ArrayList<Locality>();
            for (int i = 0; i < localities.getLength(); ++i) {
                Node locality = localities.item(i);
                Locality l = new Locality();
                l.setCategory(XMLUtils.getNodeText((Node)locality, (String)"category"));
                l.setId(XMLUtils.getNodeText((Node)locality, (String)"id"));
                l.setLatitude(XMLUtils.getNodeText((Node)locality, (String)"latitude"));
                l.setLongitude(XMLUtils.getNodeText((Node)locality, (String)"logitude"));
                l.setLocation(XMLUtils.getNodeText((Node)locality, (String)"location"));
                l.setPostcode(XMLUtils.getNodeText((Node)locality, (String)"postcode"));
                l.setState(XMLUtils.getNodeText((Node)locality, (String)"state"));
                ret.add(l);
            }
            ArrayList<Locality> arrayList = ret;
            return arrayList;
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public AusPostPostcodeService() {
    }
}

