/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.error;

import com.anahata.util.formatting.Displayable;
import com.anahata.yam.service.error.ServiceErrorCode;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class ServiceException
extends RuntimeException {
    private Set<ServiceErrorDetail> errors = new HashSet<ServiceErrorDetail>();

    public ServiceException() {
    }

    public ServiceException(String message) {
        super(message);
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public ServiceException(Throwable cause) {
        super(cause);
    }

    public ServiceException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public ServiceException(ServiceErrorCode errorCode, Object ... args) {
        this.errors.add(new ServiceErrorDetail(errorCode, args));
    }

    public ServiceException(String message, ServiceErrorCode errorCode, Object ... args) {
        super(message);
        this.errors.add(new ServiceErrorDetail(errorCode, args));
    }

    public void addError(ServiceErrorCode errorCode, Object ... args) {
        this.errors.add(new ServiceErrorDetail(errorCode, args));
    }

    public ServiceErrorDetail getError(ServiceErrorCode errorCode) {
        Validate.notNull((Object)((Object)errorCode));
        for (ServiceErrorDetail error : this.errors) {
            if (error.getErrorCode() != errorCode) continue;
            return error;
        }
        return null;
    }

    public Set<ServiceErrorDetail> getErrors() {
        return this.errors;
    }

    public static class ServiceErrorDetail
    implements Displayable,
    Serializable {
        private ServiceErrorCode errorCode;
        private Object[] args;

        public ServiceErrorDetail(ServiceErrorCode errorCode, Object ... args) {
            Validate.notNull((Object)((Object)errorCode));
            this.errorCode = errorCode;
            this.args = args;
        }

        public String getDisplayValue() {
            return String.format(this.errorCode.getDisplayValue(), this.args);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceErrorDetail)) {
                return false;
            }
            ServiceErrorDetail other = (ServiceErrorDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ServiceErrorCode this$errorCode = this.getErrorCode();
            ServiceErrorCode other$errorCode = other.getErrorCode();
            return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceErrorDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServiceErrorCode $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
            return result;
        }

        public ServiceErrorCode getErrorCode() {
            return this.errorCode;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }
}

