/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.service.abn;

import au.gov.business.abr.abrxmlsearch.ABRXMLSearch;
import au.gov.business.abr.abrxmlsearch.Payload;
import au.gov.business.abr.abrxmlsearch.Response;
import au.gov.business.abr.abrxmlsearch.SearchResultsRecord;
import com.anahata.util.formatting.FormattingUtils;
import com.anahata.yam.model.company.AbnSearchResult;
import com.anahata.yam.model.company.AbnSearchResultImpl;
import com.anahata.yam.model.location.AustralianState;
import com.anahata.yam.service.abn.AbnLookupService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class AbnLookupServiceImpl
implements AbnLookupService {
    private static final String GUID = "b6deb1f5-31c9-4b43-beb8-2bac14bcfda0";

    @Override
    public AbnSearchResult lookup(String abn, boolean includeHistorical) {
        Payload p = new ABRXMLSearch().getABRXMLSearchSoap12().abrSearchByABN(abn, AbnLookupServiceImpl.encodeBooleanParam(includeHistorical), GUID);
        Response response = p.getResponse();
        return new AbnSearchResultImpl(response);
    }

    @Override
    public List<AbnSearchResult> lookupName(String companyName) {
        return this.lookupName(companyName, AustralianState.values());
    }

    @Override
    public List<AbnSearchResult> lookupName(String companyName, AustralianState ... states) {
        String nsw = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.NSW)));
        String sa = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.SA)));
        String act = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.ACT)));
        String vic = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.VIC)));
        String wa = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.WA)));
        String nt = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.NT)));
        String qld = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.QLD)));
        String tas = AbnLookupServiceImpl.encodeBooleanParam(ArrayUtils.contains((Object[])states, (Object)((Object)AustralianState.TAS)));
        ArrayList<AbnSearchResult> l = new ArrayList<AbnSearchResult>();
        Payload p = new ABRXMLSearch().getABRXMLSearchSoap12().abrSearchByNameAdvancedSimpleProtocol2012(companyName, "", "", "", "", nsw, sa, act, vic, wa, nt, qld, tas, GUID, "Typical", "", "100");
        if (p.getResponse().getException() == null) {
            List searchResultsRecord = p.getResponse().getSearchResultsList().getSearchResultsRecord();
            for (SearchResultsRecord searchResultsRecord1 : searchResultsRecord) {
                AbnSearchResultImpl sr = new AbnSearchResultImpl(searchResultsRecord1);
                if (!sr.isCurrent()) continue;
                l.add(sr);
            }
        }
        return l;
    }

    private static String encodeBooleanParam(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public static void main(String[] args) {
        System.out.println(FormattingUtils.collectionToTableString(new AbnLookupServiceImpl().lookupName("Anahata")));
    }
}

