/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.user.password;

import com.anahata.yam.model.user.User;
import com.anahata.yam.model.user.password.ChangePassword;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ResetPassword
extends ChangePassword {
    private PasswordMode passwordMode;
    private final String generatedPassword;
    private boolean changePassword;
    private boolean emailPassword;
    private boolean showGeneratedPassword;
    private String emailAddress;
    private boolean validEmailAddress;

    public ResetPassword(@NonNull User user) {
        super(user);
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.generatedPassword = UUID.randomUUID().toString().substring(0, 8);
        if (user.getEmail() != null) {
            this.passwordMode = PasswordMode.GENERATE;
            this.changePassword = true;
            this.emailAddress = (String)StringUtils.defaultIfBlank((CharSequence)user.getEmail(), null);
            this.validEmailAddress = true;
        } else {
            this.passwordMode = PasswordMode.ENTER;
            this.changePassword = false;
            this.emailAddress = null;
            this.validEmailAddress = false;
        }
        if (this.emailAddress != null) {
            this.emailPassword = true;
            this.showGeneratedPassword = false;
        } else {
            this.emailPassword = false;
            this.showGeneratedPassword = true;
        }
    }

    @Override
    public String getPassword() {
        String password = this.passwordMode == PasswordMode.GENERATE ? this.generatedPassword : this.userPassword;
        return password;
    }

    public void setPasswordMode(PasswordMode passwordMode) {
        Validate.notNull((Object)((Object)passwordMode));
        this.passwordMode = passwordMode;
        if (passwordMode == PasswordMode.GENERATE) {
            this.userPassword = null;
            this.repeatPassword = null;
        }
    }

    @Override
    public boolean isSkipRules() {
        return this.passwordMode == PasswordMode.GENERATE;
    }

    public PasswordMode getPasswordMode() {
        return this.passwordMode;
    }

    public String getGeneratedPassword() {
        return this.generatedPassword;
    }

    public boolean isChangePassword() {
        return this.changePassword;
    }

    public boolean isEmailPassword() {
        return this.emailPassword;
    }

    public boolean isShowGeneratedPassword() {
        return this.showGeneratedPassword;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public boolean isValidEmailAddress() {
        return this.validEmailAddress;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public void setEmailPassword(boolean emailPassword) {
        this.emailPassword = emailPassword;
    }

    public void setShowGeneratedPassword(boolean showGeneratedPassword) {
        this.showGeneratedPassword = showGeneratedPassword;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setValidEmailAddress(boolean validEmailAddress) {
        this.validEmailAddress = validEmailAddress;
    }

    public static enum PasswordMode {
        ENTER,
        GENERATE;

    }
}

