/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.user.password;

import com.anahata.util.lang.Nvl;
import com.anahata.yam.model.user.password.ChangePassword;
import com.anahata.yam.model.user.password.Password;
import com.anahata.yam.model.user.password.PasswordRule;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidator
implements ConstraintValidator<Password, ChangePassword> {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidator.class);
    String field = "";

    public void initialize(Password constraintAnnotation) {
        this.field = constraintAnnotation.field();
    }

    public boolean isValid(ChangePassword value, ConstraintValidatorContext context) {
        if (value.isSkipRules()) {
            return true;
        }
        log.debug("Validating password " + value.getPassword() + " for user: " + value.getUser());
        boolean valid = true;
        for (PasswordRule rule : value.getUser().getPasswordRules()) {
            if (rule.isValid(value.getUser(), Nvl.nvl((String)value.getPassword()))) continue;
            log.debug("Rule doesn't match for {} : {} ", (Object)value.getPassword(), (Object)rule.getDescription());
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(rule.getDescription()).addPropertyNode("#" + this.field).addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

