/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.user;

import com.anahata.util.formatting.Displayable;
import com.anahata.util.lang.Nvl;
import com.anahata.util.model.Activatable;
import com.anahata.yam.model.Base;
import com.anahata.yam.model.user.Group;
import com.anahata.yam.model.user.password.PasswordRule;
import com.anahata.yam.model.user.password.UserPasswordLengthRule;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class User
extends Base
implements Serializable,
Activatable,
Displayable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Basic(optional=false)
    @Size(min=3, max=32)
    @NotNull
    @Column(name="USERNAME", nullable=false, length=32)
    private String userName;
    @Basic(optional=false)
    @Size(min=1, max=64)
    @NotNull
    @Column(name="PASSWORD", nullable=false, length=64)
    private String password;
    @Basic(optional=false)
    @Column(name="CHANGEPASSWORD", nullable=false)
    private boolean changePassword = true;
    @Size(max=255)
    @Column(name="NOTES", length=255)
    private String notes;
    @Basic(optional=false)
    @NotNull
    @Column(name="ACTIVE", nullable=false)
    private boolean active = true;
    @OneToMany
    @JoinTable(name="USER_USERGROUP", joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="USERGROUP_ID")})
    private Set<Group> groups = new HashSet<Group>();
    @Basic
    private boolean online = false;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastRequestDate;

    public User() {
    }

    public User(Long id) {
        super(id);
    }

    public boolean isInGroups(Enum ... ids) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        for (Group group : this._persistence_get_groups()) {
            for (Enum id : ids) {
                if (!id.name().equalsIgnoreCase(group.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract String getFullName();

    public abstract String getEmail();

    public abstract String getMobile();

    public abstract Long getContactId();

    public String getDisplayValue() {
        return StringUtils.isBlank((CharSequence)this.getFullName()) ? this.getUserName() : this.getFullName();
    }

    public String getFullEmailAddress() {
        if (this.getEmail() != null) {
            try {
                return new InternetAddress(this.getEmail(), Nvl.nvl((String)this.getFullName())).toUnicodeString();
            }
            catch (UnsupportedEncodingException e) {
                return this.getEmail();
            }
        }
        return null;
    }

    public List<PasswordRule> getPasswordRules() {
        return Arrays.asList(new UserPasswordLengthRule(3, 10));
    }

    public String getUserName() {
        return this._persistence_get_userName();
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public boolean isChangePassword() {
        return this._persistence_get_changePassword();
    }

    public String getNotes() {
        return this._persistence_get_notes();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public Set<Group> getGroups() {
        return this._persistence_get_groups();
    }

    public boolean isOnline() {
        return this._persistence_get_online();
    }

    public Date getLastRequestDate() {
        return this._persistence_get_lastRequestDate();
    }

    public void setUserName(String userName) {
        this._persistence_set_userName(userName);
    }

    public void setPassword(String password) {
        this._persistence_set_password(password);
    }

    public void setChangePassword(boolean changePassword) {
        this._persistence_set_changePassword(changePassword);
    }

    public void setNotes(String notes) {
        this._persistence_set_notes(notes);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setGroups(Set<Group> groups) {
        this._persistence_set_groups(groups);
    }

    public void setOnline(boolean online) {
        this._persistence_set_online(online);
    }

    public void setLastRequestDate(Date lastRequestDate) {
        this._persistence_set_lastRequestDate(lastRequestDate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new User();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "password") {
            return this.password;
        }
        if (string == "notes") {
            return this.notes;
        }
        if (string == "lastRequestDate") {
            return this.lastRequestDate;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "online") {
            return this.online;
        }
        if (string == "groups") {
            return this.groups;
        }
        if (string == "userName") {
            return this.userName;
        }
        if (string == "changePassword") {
            return this.changePassword;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "notes") {
            this.notes = (String)object;
            return;
        }
        if (string == "lastRequestDate") {
            this.lastRequestDate = (Date)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "online") {
            this.online = (Boolean)object;
            return;
        }
        if (string == "groups") {
            this.groups = (Set)object;
            return;
        }
        if (string == "userName") {
            this.userName = (String)object;
            return;
        }
        if (string == "changePassword") {
            this.changePassword = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this._persistence_propertyChange("password", this.password, string);
        this.password = string;
    }

    public String _persistence_get_notes() {
        this._persistence_checkFetched("notes");
        return this.notes;
    }

    public void _persistence_set_notes(String string) {
        this._persistence_checkFetchedForSet("notes");
        this._persistence_propertyChange("notes", this.notes, string);
        this.notes = string;
    }

    public Date _persistence_get_lastRequestDate() {
        this._persistence_checkFetched("lastRequestDate");
        return this.lastRequestDate;
    }

    public void _persistence_set_lastRequestDate(Date date) {
        this._persistence_checkFetchedForSet("lastRequestDate");
        this._persistence_propertyChange("lastRequestDate", this.lastRequestDate, date);
        this.lastRequestDate = date;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public boolean _persistence_get_online() {
        this._persistence_checkFetched("online");
        return this.online;
    }

    public void _persistence_set_online(boolean bl) {
        this._persistence_checkFetchedForSet("online");
        this._persistence_propertyChange("online", new Boolean(this.online), new Boolean(bl));
        this.online = bl;
    }

    public Set _persistence_get_groups() {
        this._persistence_checkFetched("groups");
        return this.groups;
    }

    public void _persistence_set_groups(Set set) {
        this._persistence_checkFetchedForSet("groups");
        this._persistence_propertyChange("groups", this.groups, set);
        this.groups = set;
    }

    public String _persistence_get_userName() {
        this._persistence_checkFetched("userName");
        return this.userName;
    }

    public void _persistence_set_userName(String string) {
        this._persistence_checkFetchedForSet("userName");
        this._persistence_propertyChange("userName", this.userName, string);
        this.userName = string;
    }

    public boolean _persistence_get_changePassword() {
        this._persistence_checkFetched("changePassword");
        return this.changePassword;
    }

    public void _persistence_set_changePassword(boolean bl) {
        this._persistence_checkFetchedForSet("changePassword");
        this._persistence_propertyChange("changePassword", new Boolean(this.changePassword), new Boolean(bl));
        this.changePassword = bl;
    }

    public static class ActiveLastUserNameComparator
    implements Comparator<User> {
        @Override
        public int compare(User o1, User o2) {
            if (o1.isActive() && !o2.isActive()) {
                return -1;
            }
            if (o2.isActive() && !o1.isActive()) {
                return 1;
            }
            String name1 = Nvl.nvl((String)o1.getDisplayValue()).toLowerCase();
            String name2 = Nvl.nvl((String)o2.getDisplayValue()).toLowerCase();
            return name1.compareTo(name2);
        }
    }
}

