/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.template.docmosis;

import com.anahata.yam.model.dms.TemplateDocument;
import com.anahata.yam.model.template.Template;
import com.anahata.yam.service.dms.storage.StorageService;
import com.docmosis.template.TemplateDetails;
import com.docmosis.template.analysis.TemplateAnalysis;
import com.docmosis.template.store.TemplateIdentifier;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DocmosisTemplateAdapter
implements com.docmosis.template.Template {
    private final TemplateIdentifier templateIdentifier;
    private final byte[] workingTemplate;
    private final TemplateDetails details;

    public DocmosisTemplateAdapter(Template template) {
        this.templateIdentifier = new TemplateIdentifier(template.getId().toString());
        this.details = new TemplateDetails(this.templateIdentifier, (long)template.getContent().length, template.getLastModified().getTime(), (long)template.getWorkingCopy().length, template.getLastModified().getTime(), template.getAnalysis(), null);
        this.workingTemplate = template.getWorkingCopy();
    }

    public DocmosisTemplateAdapter(TemplateDocument templateDocument, StorageService storageService) {
        this.templateIdentifier = new TemplateIdentifier(templateDocument.getTemplateId());
        this.workingTemplate = templateDocument.getDocmosisWorkingCopy();
        this.details = new TemplateDetails(this.templateIdentifier, templateDocument.getDocmosisWorkingRevision().getFileSize().longValue(), templateDocument.getDocmosisWorkingRevision().getAddedOn().getTime(), (long)templateDocument.getDocmosisWorkingCopy().length, templateDocument.getDocmosisWorkingRevision().getAddedOn().getTime(), templateDocument.getDocmosisAnalysis(), null);
    }

    public TemplateIdentifier getId() {
        return this.templateIdentifier;
    }

    public TemplateDetails getDetails() {
        return this.details;
    }

    public TemplateAnalysis getAnalysis() {
        return this.details.getAnalysis();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.workingTemplate);
    }

    public long getLength() {
        return this.workingTemplate.length;
    }

    public void cleanup() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @ConstructorProperties(value={"templateIdentifier", "workingTemplate", "details"})
    public DocmosisTemplateAdapter(TemplateIdentifier templateIdentifier, byte[] workingTemplate, TemplateDetails details) {
        this.templateIdentifier = templateIdentifier;
        this.workingTemplate = workingTemplate;
        this.details = details;
    }
}

