/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.template;

import com.anahata.util.model.Activatable;
import com.anahata.util.swing.checksum.ChecksumUtils;
import com.anahata.yam.model.template.TemplateType;
import com.anahata.yam.tech.docmosis.AnahataODFTemplateAnalyzer;
import com.docmosis.template.analysis.TemplateAnalysis;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="TEMPLATE")
@Deprecated
public class Template
implements Serializable,
Activatable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    @Id
    @Column(name="ID")
    @NotNull
    private String id;
    @NotNull
    @Basic(optional=false)
    @Column(name="NAME")
    @Size(max=255)
    private String name;
    @NotNull
    @Basic(optional=false)
    @Column(name="CONTENT")
    private byte[] content;
    @NotNull
    @Basic(optional=false)
    @Column(name="WORKINGCOPY")
    private byte[] workingCopy;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LASTMODIFIED")
    @NotNull
    private Date lastModified;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE")
    @NotNull
    @Basic(optional=false)
    private TemplateType type = TemplateType.CONTENT;
    @Column(name="CONTEXT")
    @Size(max=255)
    @NotNull
    @Basic(optional=false)
    private String context = "/";
    @Column(name="ANALYSIS")
    @Lob
    private TemplateAnalysis analysis;
    @Column(name="THUMBNAIL")
    @Basic(optional=false)
    @Lob
    private byte[] thumbnail;
    @Basic(optional=false)
    @Column(name="ACTIVE")
    private boolean active = true;
    @Basic(optional=false)
    @Column(name="CHECKSUM")
    private Long checksum;
    static final long serialVersionUID = -9164707435981020794L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public void setContent(File file) throws IOException {
        String ext = FilenameUtils.getExtension((String)file.getName());
        Validate.isTrue((boolean)"odt".equals(ext), (String)"Template file must be .odt", (Object[])new Object[0]);
        this._persistence_set_content(FileUtils.readFileToByteArray((File)file));
        this._persistence_set_lastModified(new Date(file.lastModified()));
    }

    public void setContent(byte[] content) {
        this._persistence_set_content(content);
        this._persistence_set_lastModified(new Date());
    }

    public long getSize() {
        return this._persistence_get_content() != null ? (long)this._persistence_get_content().length : 0L;
    }

    @PostLoad
    @PrePersist
    @PreUpdate
    public void checkState() throws Exception {
        long latestChecksum = ChecksumUtils.crc32((byte[])this._persistence_get_content());
        if (this._persistence_get_checksum() == null || latestChecksum != this._persistence_get_checksum() || this._persistence_get_analysis() == null || this._persistence_get_thumbnail() == null || this._persistence_get_workingCopy() == null) {
            try {
                log.debug("Generating analysis and thumbnail of template {}", (Object)this._persistence_get_id());
                AnahataODFTemplateAnalyzer ata = new AnahataODFTemplateAnalyzer(this._persistence_get_content());
                this._persistence_set_workingCopy(ata.getWorkingTemplate());
                this._persistence_set_analysis(ata.getAnalysis());
                this._persistence_set_thumbnail(ata.getThumnbail());
                Validate.notNull((Object)this._persistence_get_workingCopy(), (String)"Could not create tempalte working copy", (Object[])new Object[0]);
                Validate.notNull((Object)this._persistence_get_analysis(), (String)"Could not create template analysis", (Object[])new Object[0]);
                Validate.notNull((Object)this._persistence_get_thumbnail(), (String)"Could not create template thumbnail", (Object[])new Object[0]);
                this._persistence_set_checksum(ChecksumUtils.crc32((byte[])this._persistence_get_content()));
                log.debug("Analysis and thumbnail of template {} generated, checksum = , lastModified=", new Object[]{this._persistence_get_id(), this._persistence_get_checksum(), this._persistence_get_lastModified()});
            }
            catch (Exception e) {
                log.error("Error creating analysis and thumbnail of " + this._persistence_get_id(), (Throwable)e);
                throw new RuntimeException("Error creating analysis and thumbnail of " + this._persistence_get_id(), e);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public byte[] getContent() {
        return this._persistence_get_content();
    }

    public byte[] getWorkingCopy() {
        return this._persistence_get_workingCopy();
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    public TemplateType getType() {
        return this._persistence_get_type();
    }

    public String getContext() {
        return this._persistence_get_context();
    }

    public TemplateAnalysis getAnalysis() {
        return this._persistence_get_analysis();
    }

    public byte[] getThumbnail() {
        return this._persistence_get_thumbnail();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public Long getChecksum() {
        return this._persistence_get_checksum();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public void setLastModified(Date lastModified) {
        this._persistence_set_lastModified(lastModified);
    }

    public void setType(TemplateType type) {
        this._persistence_set_type(type);
    }

    public void setContext(String context) {
        this._persistence_set_context(context);
    }

    public void setAnalysis(TemplateAnalysis analysis) {
        this._persistence_set_analysis(analysis);
    }

    public void setThumbnail(byte[] thumbnail) {
        this._persistence_set_thumbnail(thumbnail);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setChecksum(Long checksum) {
        this._persistence_set_checksum(checksum);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Template();
    }

    public Object _persistence_get(String string) {
        if (string == "thumbnail") {
            return this.thumbnail;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "context") {
            return this.context;
        }
        if (string == "checksum") {
            return this.checksum;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "workingCopy") {
            return this.workingCopy;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "analysis") {
            return this.analysis;
        }
        if (string == "content") {
            return this.content;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "thumbnail") {
            this.thumbnail = (byte[])object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "context") {
            this.context = (String)object;
            return;
        }
        if (string == "checksum") {
            this.checksum = (Long)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "workingCopy") {
            this.workingCopy = (byte[])object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        if (string == "type") {
            this.type = (TemplateType)((Object)object);
            return;
        }
        if (string == "analysis") {
            this.analysis = (TemplateAnalysis)object;
            return;
        }
        if (string == "content") {
            this.content = (byte[])object;
            return;
        }
    }

    public byte[] _persistence_get_thumbnail() {
        this._persistence_checkFetched("thumbnail");
        return this.thumbnail;
    }

    public void _persistence_set_thumbnail(byte[] byArray) {
        this._persistence_checkFetchedForSet("thumbnail");
        this._persistence_propertyChange("thumbnail", this.thumbnail, byArray);
        this.thumbnail = byArray;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_context() {
        this._persistence_checkFetched("context");
        return this.context;
    }

    public void _persistence_set_context(String string) {
        this._persistence_checkFetchedForSet("context");
        this._persistence_propertyChange("context", this.context, string);
        this.context = string;
    }

    public Long _persistence_get_checksum() {
        this._persistence_checkFetched("checksum");
        return this.checksum;
    }

    public void _persistence_set_checksum(Long l) {
        this._persistence_checkFetchedForSet("checksum");
        this._persistence_propertyChange("checksum", this.checksum, l);
        this.checksum = l;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public byte[] _persistence_get_workingCopy() {
        this._persistence_checkFetched("workingCopy");
        return this.workingCopy;
    }

    public void _persistence_set_workingCopy(byte[] byArray) {
        this._persistence_checkFetchedForSet("workingCopy");
        this._persistence_propertyChange("workingCopy", this.workingCopy, byArray);
        this.workingCopy = byArray;
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }

    public TemplateType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(TemplateType templateType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", (Object)this.type, (Object)templateType);
        this.type = templateType;
    }

    public TemplateAnalysis _persistence_get_analysis() {
        this._persistence_checkFetched("analysis");
        return this.analysis;
    }

    public void _persistence_set_analysis(TemplateAnalysis templateAnalysis) {
        this._persistence_checkFetchedForSet("analysis");
        this._persistence_propertyChange("analysis", this.analysis, templateAnalysis);
        this.analysis = templateAnalysis;
    }

    public byte[] _persistence_get_content() {
        this._persistence_checkFetched("content");
        return this.content;
    }

    public void _persistence_set_content(byte[] byArray) {
        this._persistence_checkFetchedForSet("content");
        this._persistence_propertyChange("content", this.content, byArray);
        this.content = byArray;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

