/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.search;

import com.anahata.yam.model.company.CompanySortKey;
import com.anahata.yam.model.search.AbstractSearchRequest;
import java.io.Serializable;

public class FullTextSearchRequest
extends AbstractSearchRequest
implements Serializable {
    private String query = "";
    private boolean matchAllTokens;
    private boolean expandSearch = true;

    public void setQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.query = query.trim();
    }

    public boolean isEmptyQuery() {
        return this.query.length() == 0;
    }

    public static FullTextSearchRequest newAutocomplete(String text) {
        FullTextSearchRequest sr = new FullTextSearchRequest();
        sr.setQuery(text);
        sr.setPageSize(7);
        sr.setStartPage(0);
        sr.setExpandSearch(false);
        sr.setMatchAllTokens(true);
        sr.setSortKey(CompanySortKey.SCORE);
        sr.setIncludeDeleted(false);
        return sr;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isMatchAllTokens() {
        return this.matchAllTokens;
    }

    public boolean isExpandSearch() {
        return this.expandSearch;
    }

    public void setMatchAllTokens(boolean matchAllTokens) {
        this.matchAllTokens = matchAllTokens;
    }

    public void setExpandSearch(boolean expandSearch) {
        this.expandSearch = expandSearch;
    }

    public String toString() {
        return "FullTextSearchRequest(query=" + this.getQuery() + ", matchAllTokens=" + this.isMatchAllTokens() + ", expandSearch=" + this.isExpandSearch() + ")";
    }
}

