/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.phone;

import com.anahata.util.validator.constraints.PhoneNumberValidator;
import com.anahata.yam.model.location.Country;
import com.anahata.yam.model.search.Searchable;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class PhoneNumber
implements Serializable,
Searchable {
    private static final String[] REMOVE_CHAR_SEARCH = new String[]{"(", ")", "-", "."};
    private static final String[] REMOVE_CHAR_REPLACE = new String[]{"", "", "", ""};
    @com.anahata.util.validator.constraints.PhoneNumber
    private String rawPhoneNumber = null;
    private Phonenumber.PhoneNumber phoneNumber = null;

    public PhoneNumber(String value) {
        this(value, null);
    }

    public PhoneNumber(String value, Country country) {
        this.rawPhoneNumber = value;
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Iterable numbers = phoneNumberUtil.findNumbers((CharSequence)value, country == null ? null : country.name());
        Iterator iter = numbers.iterator();
        if (iter.hasNext()) {
            PhoneNumberMatch match = (PhoneNumberMatch)iter.next();
            this.phoneNumber = match.number();
        } else {
            numbers = phoneNumberUtil.findNumbers((CharSequence)value, Country.AU.name());
            iter = numbers.iterator();
            if (iter.hasNext()) {
                PhoneNumberMatch match = (PhoneNumberMatch)iter.next();
                this.phoneNumber = match.number();
            }
        }
    }

    public String getValue() {
        return this.phoneNumber != null ? PhoneNumberUtil.getInstance().format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164) : null;
    }

    public String getNationalValue() {
        if (this.phoneNumber == null) {
            return null;
        }
        String value = StringUtils.deleteWhitespace((String)PhoneNumberUtil.getInstance().format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        value = StringUtils.replaceEach((String)value, (String[])REMOVE_CHAR_SEARCH, (String[])REMOVE_CHAR_REPLACE);
        return value;
    }

    public String getDisplayValue() {
        if (this.phoneNumber == null) {
            return this.rawPhoneNumber;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        if (Country.AU.name().equals(phoneNumberUtil.getRegionCodeForNumber(this.phoneNumber))) {
            return phoneNumberUtil.formatNationalNumberWithCarrierCode(this.phoneNumber, null);
        }
        return phoneNumberUtil.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
    }

    public String toString() {
        return "Raw value: " + this.rawPhoneNumber;
    }

    public boolean isValid() {
        return PhoneNumberValidator.isValid((String)this.rawPhoneNumber);
    }

    public static void main(String[] args) {
        String s = new PhoneNumber("041").getDisplayValue();
        System.out.println("s=" + s);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhoneNumber)) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Phonenumber.PhoneNumber this$phoneNumber = this.phoneNumber;
        Phonenumber.PhoneNumber other$phoneNumber = other.phoneNumber;
        return !(this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PhoneNumber;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Phonenumber.PhoneNumber $phoneNumber = this.phoneNumber;
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        return result;
    }
}

