/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.location;

import java.util.Currency;

public enum Country {
    AF("Afghanistan", "AFG", "AFN"),
    AL("Albania", "ALB", "ALL"),
    AX("Aland Islands", "ALA", new String[0]),
    DZ("Algeria", "DZA", "DZD"),
    AS("American Samoa", "ASM", "USD"),
    AD("Andorra", "AND", "EUR"),
    AO("Angola", "AGO", "AOA"),
    AI("Anguilla", "AIA", "XCD"),
    AG("Antigua and Barbuda", "ATG", "XCD"),
    AR("Argentina", "ARG", "ARS"),
    AM("Armenia", "ARM", "AMD"),
    AW("Aruba", "ABW", "AWG"),
    AU("Australia", "AUS", "AUD"),
    AT("Austria", "AUT", "EUR"),
    AZ("Azerbaijan", "AZE", "AZN"),
    BS("Bahamas", "BHS", "BSD"),
    BH("Bahrain", "BHR", "BHD"),
    BD("Bangladesh", "BGD", "BDT"),
    BB("Barbados", "BRB", "BBD"),
    BY("Belarus", "BLR", "BYR"),
    BE("Belgium", "BEL", "EUR"),
    BZ("Belize", "BLZ", "BZD"),
    BJ("Benin", "BEN", "XOF"),
    BM("Bermuda", "BMU", "BMD"),
    BT("Bhutan", "BTN", "INR", "BTN"),
    BO("Bolivia", "BOL", "BOB", "BOV"),
    BA("Bosnia and Herzegovina", "BIH", "BAM"),
    BW("Botswana", "BWA", "BWP"),
    BV("Bouvet Island", "BVT", "NOK"),
    BR("Brazil", "BRA", "BRL"),
    IO("British Indian Ocean Territory", "IOT", "USD"),
    BN("Brunei Darussalam", "BRN", "BND"),
    BG("Bulgaria", "BGR", "BGN"),
    BF("Burkina Faso", "BFA", "XOF"),
    BI("Burundi", "BDI", "BIF"),
    KH("Cambodia", "KHM", "KHR"),
    CM("Cameroon", "CMR", "XAF"),
    CA("Canada", "CAN", "CAD"),
    CV("Cape Verde", "CPV", "CVE"),
    KY("Cayman Islands", "CYM", "KYD"),
    CF("Central African Republic", "CAF", "XAF"),
    TD("Chad", "TCD", "XAF"),
    CL("Chile", "CHL", "CLP", "CLF"),
    CN("China", "CHN", "CNY"),
    CX("Christmas Island", "CXR", "AUD"),
    CC("Cocos (Keeling) Islands", "CCK", "AUD"),
    CO("Colombia", "COL", "COP", "COU"),
    KM("Comoros", "COM", "KMF"),
    CG("Congo", "COG", "XAF"),
    CD("Congo, The Democratic Republic Of The", "COD", "CDF"),
    CK("Cook Islands", "COK", "NZD"),
    CR("Costa Rica", "CRI", "CRC"),
    HR("Croatia", "HRV", "HRK"),
    CI("C\ufffd\ufffdte D'Ivoire", "CIV", "XOF"),
    CU("Cuba", "CUB", "CUP"),
    CY("Cyprus", "CYP", "EUR"),
    CZ("Czech Republic", "CZE", "CZK"),
    DK("Denmark", "DNK", "DKK"),
    DJ("Djibouti", "DJI", "DJF"),
    DM("Dominica", "DMA", "XCD"),
    DO("Dominican Republic", "DOM", "DOP"),
    EC("Ecuador", "ECU", "USD"),
    EG("Egypt", "EGY", "EGP"),
    SV("El Salvador", "SLV", "SVC", "USD"),
    GQ("Equatorial Guinea", "GNQ", "XAF"),
    ER("Eritrea", "ERI", "ERN"),
    EE("Estonia", "EST", "EEK"),
    ET("Ethiopia", "ETH", "ETB"),
    FK("Falkland Islands (Malvinas)", "FLK", "FKP"),
    FO("Faroe Islands", "FRO", "DKK"),
    FJ("Fiji", "FJI", "FJD"),
    FI("Finland", "FIN", "EUR"),
    FR("France", "FRA", "EUR"),
    GF("French Guiana", "GUF", "EUR"),
    PF("French Polynesia", "PYF", "XPF"),
    TF("French Southern Territories", "ATF", "EUR"),
    GA("Gabon", "GAB", "XAF"),
    GM("Gambia", "GMB", "GMD"),
    GE("Georgia", "GEO", "GEL"),
    DE("Germany", "DEU", "EUR"),
    GH("Ghana", "GHA", "GHS"),
    GI("Gibraltar", "GIB", "GIP"),
    GR("Greece", "GRC", "EUR"),
    GL("Greenland", "GRL", "DKK"),
    GD("Grenada", "GRD", "XCD"),
    GP("Guadeloupe", "GLP", "EUR"),
    GU("Guam", "GUM", "USD"),
    GT("Guatemala", "GTM", "GTQ"),
    GN("Guinea", "GIN", "GNF"),
    GW("Guinea-Bissau", "GNB", "XOF", "GWP"),
    GY("Guyana", "GUY", "GYD"),
    HT("Haiti", "HTI", "HTG", "USD"),
    HM("Heard and McDonald Islands", "HMD", "AUD"),
    VA("Holy See (Vatican City State)", "VAT", "EUR"),
    HN("Honduras", "HND", "HNL"),
    HK("Hong Kong", "HKG", "HKD"),
    HU("Hungary", "HUN", "HUF"),
    IS("Iceland", "ISL", "ISK"),
    IN("India", "IND", "INR"),
    ID("Indonesia", "IDN", "IDR"),
    IR("Iran (Islamic Republic Of)", "IRN", "IRR"),
    IQ("Iraq", "IRQ", "IQD"),
    IE("Ireland", "IRL", "EUR"),
    IL("Israel", "ISR", "ILS"),
    IT("Italy", "ITA", "EUR"),
    JM("Jamaica", "JAM", "JMD"),
    JP("Japan", "JPN", "JPY"),
    JO("Jordan", "JOR", "JOD"),
    KZ("Kazakhstan", "KAZ", "KZT"),
    KE("Kenya", "KEN", "KES"),
    KI("Kiribati", "KIR", "AUD"),
    KP("Korea, Democratic People's Republic Of", "PRK", "KPW"),
    KR("Korea, Republic of", "KOR", "KRW"),
    KW("Kuwait", "KWT", "KWD"),
    KG("Kyrgyzstan", "KGZ", "KGS"),
    LA("Lao People's Democratic Republic", "LAO", "LAK"),
    LV("Latvia", "LVA", "LVL"),
    LB("Lebanon", "LBN", "LBP"),
    LS("Lesotho", "LSO", "LSL", "ZAR"),
    LR("Liberia", "LBR", "LRD"),
    LY("Libyan Arab Jamahiriya", "LBY", "LYD"),
    LI("Liechtenstein", "LIE", "CHF"),
    LT("Lithuania", "LTU", "LTL"),
    LU("Luxembourg", "LUX", "EUR"),
    MO("Macao", "MAC", "MOP"),
    MK("Macedonia, the Former Yugoslav Republic Of", "MKD", "MKD"),
    MG("Madagascar", "MDG", "MGA"),
    MW("Malawi", "MWI", "MWK"),
    MY("Malaysia", "MYS", "MYR"),
    MV("Maldives", "MDV", "MVR"),
    ML("Mali", "MLI", "XOF"),
    MT("Malta", "MLT", "EUR"),
    MH("Marshall Islands", "MHL", "USD"),
    MQ("Martinique", "MTQ", "EUR"),
    MR("Mauritania", "MRT", "MRO"),
    MU("Mauritius", "MUS", "MUR"),
    YT("Mayotte", "MYT", "EUR"),
    MX("Mexico", "MEX", "MXN", "MXV"),
    FM("Micronesia, Federated States Of", "FSM", "USD"),
    MD("Moldova", "MDA", "MDL"),
    MC("Monaco", "MCO", "EUR"),
    MN("Mongolia", "MNG", "MNT"),
    ME("Montenegro", "MNE", "EUR"),
    MS("Montserrat", "MSR", "XCD"),
    MA("Morocco", "MAR", "MAD"),
    MZ("Mozambique", "MOZ", "MZN"),
    MM("Myanmar", "MMR", "MMK"),
    NA("Namibia", "NAM", "NAD", "ZAR"),
    NR("Nauru", "NRU", "AUD"),
    NP("Nepal", "NPL", "NPR"),
    NL("Netherlands", "NLD", "EUR"),
    AN("Netherlands Antilles", "ANT", "ANG"),
    NC("New Caledonia", "NCL", "XPF"),
    NZ("New Zealand", "NZL", "NZD"),
    NI("Nicaragua", "NIC", "NIO"),
    NE("Niger", "NER", "XOF"),
    NG("Nigeria", "NGA", "NGN"),
    NU("Niue", "NIU", "NZD"),
    NF("Norfolk Island", "NFK", "AUD"),
    MP("Northern Mariana Islands", "MNP", "USD"),
    NO("Norway", "NOR", "NOK"),
    OM("Oman", "OMN", "OMR"),
    PK("Pakistan", "PAK", "PKR"),
    PW("Palau", "PLW", "USD"),
    PA("Panama", "PAN", "PAB", "USD"),
    PG("Papua New Guinea", "PNG", "PGK"),
    PY("Paraguay", "PRY", "PYG"),
    PE("Peru", "PER", "PEN"),
    PH("Philippines", "PHL", "PHP"),
    PN("Pitcairn", "PCN", "NZD"),
    PL("Poland", "POL", "PLN"),
    PT("Portugal", "PRT", "EUR"),
    PR("Puerto Rico", "PRI", "USD"),
    QA("Qatar", "QAT", "QAR"),
    RO("Romania", "ROM", "RON"),
    RE("Euro Member Countries", "REU", "EUR"),
    RU("Russian Federation", "RUS", "RUB"),
    RW("Rwanda", "RWA", "RWF"),
    SH("Saint Helena", "SHN", "SHP"),
    KN("Saint Kitts And Nevis", "KNA", "XCD"),
    LC("Saint Lucia", "LCA", "XCD"),
    PM("Saint Pierre And Miquelon", "SPM", "EUR"),
    VC("Saint Vincent And The Grenedines", "VCT", "XCD"),
    WS("Samoa", "WSM", "WST"),
    SM("San Marino", "SMR", "EUR"),
    ST("Sao Tome and Principe", "STP", "STD"),
    SA("Saudi Arabia", "SAU", "SAR"),
    SN("Senegal", "SEN", "XOF"),
    RS("Serbia", "", "RSD"),
    SC("Seychelles", "SYC", "SCR"),
    SL("Sierra Leone", "SLE", "SLL"),
    SG("Singapore", "SGP", "SGD"),
    SI("Slovenia", "SVN", "EUR"),
    SB("Solomon Islands", "SLB", "SBD"),
    SO("Somalia", "SOM", "SOS"),
    ZA("South Africa", "ZAF", "ZAR"),
    ES("Spain", "ESP", "EUR"),
    LK("Sri Lanka", "LKA", "LKR"),
    SD("Sudan", "SDN", "SDG"),
    SR("Suriname", "SUR", "SRD"),
    SJ("Svalbard And Jan Mayen", "SJM", "NOK"),
    SZ("Swaziland", "SWZ", "SZL"),
    SE("Sweden", "SWE", "SEK"),
    CH("Switzerland", "CHE", "CHF", "CHE", "CHW"),
    SY("Syrian Arab Republic", "SYR", "SYP"),
    TW("Taiwan, Province Of China", "TWN", "TWD"),
    TJ("Tajikistan", "TJK", "TJS"),
    TZ("Tanzania, United Republic of", "TZA", "TZS"),
    TH("Thailand", "THA", "THB"),
    TL("Timor-Leste", "TLS", "USD"),
    TG("Togo", "TGO", "XOF"),
    TK("Tokelau", "TKL", "NZD"),
    TO("Tonga", "TON", "TOP"),
    TT("Trinidad and Tobago", "TTO", "TTD"),
    TN("Tunisia", "TUN", "TND"),
    TR("Turkey", "TUR", "TRY"),
    TM("Turkmenistan", "TKM", "TMM"),
    TC("Turks and Caicos Islands", "TCA", "USD"),
    TV("Tuvalu", "TUV", "AUD"),
    UG("Uganda", "UGA", "UGX"),
    UA("Ukraine", "UKR", "UAH"),
    AE("United Arab Emirates", "ARE", "AED"),
    GB("United Kingdom", "GBR", "GBP"),
    US("United States of America", "USA", "USD"),
    UM("United States Minor Outlying Islands", "UMI", "USD"),
    UY("Uruguay", "URY", "UYU", "UYI"),
    UZ("Uzbekistan", "UZB", "UZS"),
    VU("Vanuatu", "VUT", "VUV"),
    VE("Venezuela", "VEN", "VEF"),
    VN("Viet Nam", "VNM", "VND"),
    VG("Virgin Islands, British", "VGB", "USD"),
    VI("Virgin Islands, U.S.", "VIR", "USD"),
    WF("Wallis and Futuna", "WLF", "XPF"),
    EH("Western Sahara", "ESH", "MAD"),
    YE("Yemen", "YEM", "YER"),
    ZM("Zambia", "ZMB", "ZMK"),
    ZW("Zimbabwe", "ZWE", "ZWD");

    private String description;
    private String iso3Code;
    private String[] iso3CurrencyCodes;

    private Country(String description, String iso3Code, String ... iso3CurrencyCodes) {
        this.description = description;
        this.iso3Code = iso3Code;
        this.iso3CurrencyCodes = iso3CurrencyCodes;
    }

    public String toString() {
        return this.description;
    }

    public Currency getPrimaryCurrency() {
        return Currency.getInstance(this.iso3CurrencyCodes[0]);
    }

    public static Country forName(String name) {
        for (Country c : Country.values()) {
            if (!c.getDescription().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public static Country forIso3Code(String iso3Code) {
        for (Country c : Country.values()) {
            if (!c.getIso3Code().equalsIgnoreCase(iso3Code)) continue;
            return c;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIso3Code() {
        return this.iso3Code;
    }

    public String[] getIso3CurrencyCodes() {
        return this.iso3CurrencyCodes;
    }
}

