/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.financial;

import com.anahata.yam.model.financial.Money;
import com.anahata.yam.model.financial.MoneyAmount;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MoneyAmountValidator
implements ConstraintValidator<MoneyAmount, Money> {
    private static final String MSG_INVALID_DIGITS = "The currency value can only have a maximum of %d digits after the decimal place";

    public void initialize(MoneyAmount constraintAnnotation) {
    }

    public boolean isValid(Money value, ConstraintValidatorContext context) {
        if (value == null || value.getRawAmount() == null || value.getCurrency() == null) {
            return true;
        }
        if (value.getRawAmount().scale() > value.getCurrency().getDefaultFractionDigits()) {
            String message = String.format(MSG_INVALID_DIGITS, value.getCurrency().getDefaultFractionDigits());
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(message).addNode("amount").addConstraintViolation();
            return false;
        }
        return true;
    }
}

