/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.financial;

import com.anahata.util.financial.CurrencyUtils;
import com.anahata.util.formatting.Displayable;
import com.anahata.util.jpa.eclipselink.converter.CurrencyConverter;
import com.anahata.util.lang.Nvl;
import com.anahata.yam.model.financial.MoneyAmount;
import com.anahata.yam.model.location.Country;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlTransient;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embeddable
@Access(value=AccessType.FIELD)
@MoneyAmount
public class Money
implements Serializable,
Comparable<Money>,
Displayable,
Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final Logger log = LoggerFactory.getLogger(Money.class);
    private static Currency defaultCurrency = Currency.getInstance(Locale.getDefault());
    private static RoundingMode defaultRoundingMode = RoundingMode.HALF_EVEN;
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Column(name="AMOUNT")
    @NotNull
    private BigDecimal amount = null;
    @Column(name="CURRENCY")
    @Converter(name="currencyConverter", converterClass=CurrencyConverter.class)
    @Convert(value="currencyConverter")
    @NotNull
    private Currency currency = null;
    @Transient
    private RoundingMode roundingMode = defaultRoundingMode;
    static final long serialVersionUID = 4622134266775634531L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Money(Money money) {
        this.amount = Nvl.nvl((BigDecimal)money.getAmount());
        this.currency = money.getCurrency();
    }

    public Money(BigDecimal amount2, Currency currency2, RoundingMode roundingMode) {
        Validate.notNull((Object)amount2);
        this.currency = currency2 == null ? defaultCurrency : currency2;
        this.roundingMode = roundingMode == null ? defaultRoundingMode : roundingMode;
        this.amount = amount2.setScale(this.currency.getDefaultFractionDigits(), this.roundingMode);
    }

    public Money(BigDecimal amount2, Currency currency2) {
        this(amount2, currency2, null);
    }

    public Money(BigDecimal amount2) {
        this(amount2, null, null);
    }

    public Money(String amount2, Currency currency2, RoundingMode roundingMode) {
        this(new BigDecimal(amount2), currency2, roundingMode);
    }

    public Money(String amount2, Currency currency2) {
        this(new BigDecimal(amount2), currency2, null);
    }

    public Money(String amount2) {
        this(new BigDecimal(amount2), null, null);
    }

    public Money add(Money money) {
        Validate.notNull((Object)money, (String)"A money value is required to add", (Object[])new Object[0]);
        this.validateState();
        this.validateSameCurrency(money);
        return new Money(Nvl.nvl((BigDecimal)this._persistence_get_amount()).add(Nvl.nvl((BigDecimal)money.getAmount())), this._persistence_get_currency(), this.roundingMode);
    }

    public Money add(@NonNull BigDecimal amountToAdd) {
        if (amountToAdd == null) {
            throw new NullPointerException("amountToAdd");
        }
        this.validateState();
        return new Money(Nvl.nvl((BigDecimal)this._persistence_get_amount()).add(amountToAdd), this._persistence_get_currency(), this.roundingMode);
    }

    public Money subtract(Money money) {
        Validate.notNull((Object)money, (String)"A money value is required to subtract", (Object[])new Object[0]);
        this.validateState();
        this.validateSameCurrency(money);
        return new Money(Nvl.nvl((BigDecimal)this._persistence_get_amount()).subtract(Nvl.nvl((BigDecimal)money.getAmount())), this._persistence_get_currency(), this.roundingMode);
    }

    public static Money sum(Collection<Money> moneys, Currency currencyIfEmpty) {
        Validate.notNull(moneys);
        Validate.notNull((Object)currencyIfEmpty);
        Money sum = new Money(BigDecimal.ZERO, currencyIfEmpty, null);
        for (Money money : moneys) {
            sum = sum.add(money);
        }
        return sum;
    }

    public Money multiply(int factor) {
        this.validateState();
        return new Money(Nvl.nvl((BigDecimal)this._persistence_get_amount()).multiply(new BigDecimal(factor)), this._persistence_get_currency(), this.roundingMode);
    }

    public Money multiply(BigDecimal factor) {
        Validate.notNull((Object)factor);
        this.validateState();
        BigDecimal newAmount = Nvl.nvl((BigDecimal)this._persistence_get_amount()).multiply(factor);
        return new Money(newAmount, this._persistence_get_currency(), this.roundingMode);
    }

    public Money divide(BigDecimal divisor) {
        Validate.notNull((Object)divisor, (String)"The divisor is required", (Object[])new Object[0]);
        Validate.isTrue((divisor.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"The divisor must be greater than zero", (Object[])new Object[0]);
        BigDecimal newAmount = Nvl.nvl((BigDecimal)this._persistence_get_amount()).divide(divisor, this.roundingMode);
        return new Money(newAmount, this._persistence_get_currency(), this.roundingMode);
    }

    public Money[] divide(int divisor) {
        Validate.isTrue((divisor > 0 ? 1 : 0) != 0, (String)"The divisor must be greater than zero", (Object[])new Object[0]);
        this.validateState();
        Money[] result = new Money[divisor];
        BigDecimal simpleResult = Nvl.nvl((BigDecimal)this._persistence_get_amount()).divide(new BigDecimal(divisor), RoundingMode.DOWN);
        BigDecimal remainder = Nvl.nvl((BigDecimal)this._persistence_get_amount()).subtract(simpleResult.multiply(new BigDecimal(divisor)));
        BigDecimal increment = BigDecimal.ONE.divide(BigDecimal.TEN.pow(this._persistence_get_currency().getDefaultFractionDigits()));
        for (int i = 0; i < divisor; ++i) {
            BigDecimal value = simpleResult;
            if (remainder.compareTo(BigDecimal.ZERO) > 0) {
                value = simpleResult.add(increment);
                remainder = remainder.subtract(increment);
            }
            result[i] = new Money(value, this._persistence_get_currency(), this.roundingMode);
        }
        return result;
    }

    public Money negate() {
        this.validateState();
        if (this._persistence_get_amount() == null) {
            return null;
        }
        return new Money(this._persistence_get_amount().negate(), this._persistence_get_currency(), this.roundingMode);
    }

    public boolean greaterThan(Money money) {
        return this.compareTo(money) > 0;
    }

    public boolean lessThan(Money money) {
        return this.compareTo(money) < 0;
    }

    public boolean isZero() {
        return this._persistence_get_amount() == null || BigDecimal.ZERO.compareTo(this._persistence_get_amount()) == 0;
    }

    public boolean isAUD() {
        return this._persistence_get_currency() != null && Country.AU.getPrimaryCurrency().equals(this._persistence_get_currency());
    }

    public String getDisplayValue() {
        this.validateState();
        if (this._persistence_get_amount() == null) {
            return null;
        }
        NumberFormat format = CurrencyUtils.getCurrencyFormat((Currency)this._persistence_get_currency());
        return format != null ? format.format(this._persistence_get_amount()) : this._persistence_get_amount().toString();
    }

    public String getAmountString() {
        this.validateState();
        if (this._persistence_get_amount() == null) {
            return null;
        }
        DecimalFormat df = this.getDecimalFormat(true, true);
        if (df == null) {
            log.warn("No decimal format for currency {}", (Object)this._persistence_get_currency());
            return this._persistence_get_amount().toString();
        }
        return df.format(this.getAmount());
    }

    private DecimalFormat getDecimalFormat(boolean includeCurrencySymbol, boolean includeWhiteSpaces) {
        DecimalFormat format = (DecimalFormat)CurrencyUtils.getCurrencyFormat((Currency)this._persistence_get_currency());
        if (!includeCurrencySymbol) {
            format = new DecimalFormat(format.toPattern().replace(" ", ""));
        }
        if (!includeCurrencySymbol) {
            DecimalFormatSymbols dfs = format.getDecimalFormatSymbols();
            dfs.setCurrencySymbol("");
            format.setDecimalFormatSymbols(dfs);
        }
        return format;
    }

    public void setAmountString(String value) {
        log.debug("setAmountValue= {}", (Object)value);
        BigDecimal parsed = BigDecimal.ZERO;
        try {
            parsed = new BigDecimal(value);
            log.debug("parsed as number");
        }
        catch (Exception e) {
            for (DecimalFormat l1 : this.getDecimalFormats()) {
                try {
                    parsed = new BigDecimal(l1.parse(value).toString());
                    log.debug(value + " parsed using " + l1.toPattern());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        this._persistence_set_amount(parsed.setScale(this._persistence_get_currency().getDefaultFractionDigits(), defaultRoundingMode));
    }

    private List<DecimalFormat> getDecimalFormats() {
        ArrayList<DecimalFormat> l = new ArrayList<DecimalFormat>();
        l.add(this.getDecimalFormat(true, true));
        l.add(this.getDecimalFormat(true, false));
        l.add(this.getDecimalFormat(false, true));
        l.add(this.getDecimalFormat(false, false));
        return l;
    }

    @Override
    public int compareTo(Money money) {
        Validate.notNull((Object)money);
        this.validateState();
        this.validateSameCurrency(money);
        return ObjectUtils.compare((Comparable)this._persistence_get_amount(), (Comparable)money.getAmount());
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount() == null ? null : this._persistence_get_amount().setScale(this._persistence_get_currency().getDefaultFractionDigits(), this.roundingMode);
    }

    BigDecimal getRawAmount() {
        return this._persistence_get_amount();
    }

    private void validateState() {
        Validate.validState((this._persistence_get_currency() != null ? 1 : 0) != 0, (String)"Currency cannot be null", (Object[])new Object[0]);
        Validate.validState((this.roundingMode != null ? 1 : 0) != 0, (String)"RoundingMode cannot be null", (Object[])new Object[0]);
    }

    private void validateSameCurrency(Money money) {
        Validate.notNull((Object)money);
        Validate.isTrue((boolean)this._persistence_get_currency().equals(money._persistence_get_currency()), (String)"The currencies do not match, this is %s and other is %s", (Object[])new Object[]{this._persistence_get_currency().getCurrencyCode(), money._persistence_get_currency().getCurrencyCode()});
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Money other = (Money)obj;
        if (!Objects.equals(this._persistence_get_amount(), other._persistence_get_amount())) {
            return false;
        }
        return Objects.equals(this._persistence_get_currency(), other._persistence_get_currency());
    }

    public static void main(String[] args) {
        Money m = new Money(new BigDecimal("12345"), Country.CH.getPrimaryCurrency());
        System.out.println(m.getAmountString());
        m.setAmountString("SFr. 12'346.00");
        System.out.println(m.getAmountString());
        m.setAmountString("12'346.12");
        System.out.println(m.getAmountString());
        m.setAmountString("12346.00");
        System.out.println(m.getAmountString());
        m = new Money(new BigDecimal("12345"), Country.ES.getPrimaryCurrency());
        System.out.println(m.getAmountString());
        m.setAmountString(m.getAmountString());
        m.setAmountString("12345");
        System.out.println(m.getAmountString());
        System.out.println(m.getAmountString());
        System.out.println(m.getAmountString());
    }

    protected Money() {
    }

    public static void setDefaultCurrency(Currency defaultCurrency) {
        Money.defaultCurrency = defaultCurrency;
    }

    public static void setDefaultRoundingMode(RoundingMode defaultRoundingMode) {
        Money.defaultRoundingMode = defaultRoundingMode;
    }

    public static RoundingMode getDefaultRoundingMode() {
        return defaultRoundingMode;
    }

    public void setAmount(BigDecimal amount2) {
        this._persistence_set_amount(amount2);
    }

    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    public void setCurrency(Currency currency2) {
        this._persistence_set_currency(currency2);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Money();
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "currency") {
            return this.currency;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency2) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_propertyChange("currency", this.currency, currency2);
        this.currency = currency2;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

