/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.storage;

import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.storage.NodeStorage;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="DMSSTORAGEPROVIDER")
public abstract class StorageProvider
extends Base
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private boolean active;
    @NotNull
    private double downloadOrder;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified;
    static final long serialVersionUID = 8300560316786503311L;

    public StorageProvider() {
        this.active = true;
        this.downloadOrder = 1.0;
    }

    @Override
    public void setId(Long id) {
        super.setId(id);
    }

    @PrePersist
    @PreUpdate
    private void updateLastModified() {
        this._persistence_set_lastModified(new Date());
    }

    public abstract NodeStorage newNodeStorage(Node var1);

    public abstract boolean isOffSite();

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public double getDownloadOrder() {
        return this._persistence_get_downloadOrder();
    }

    public Date getLastModified() {
        return this._persistence_get_lastModified();
    }

    public void setDownloadOrder(double downloadOrder) {
        this._persistence_set_downloadOrder(downloadOrder);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new StorageProvider(persistenceObject);
    }

    public StorageProvider(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "downloadOrder") {
            return this.downloadOrder;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "lastModified") {
            return this.lastModified;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "downloadOrder") {
            this.downloadOrder = (Double)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "lastModified") {
            this.lastModified = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public double _persistence_get_downloadOrder() {
        this._persistence_checkFetched("downloadOrder");
        return this.downloadOrder;
    }

    public void _persistence_set_downloadOrder(double d) {
        this._persistence_checkFetchedForSet("downloadOrder");
        this._persistence_propertyChange("downloadOrder", new Double(this.downloadOrder), new Double(d));
        this.downloadOrder = d;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public Date _persistence_get_lastModified() {
        this._persistence_checkFetched("lastModified");
        return this.lastModified;
    }

    public void _persistence_set_lastModified(Date date) {
        this._persistence_checkFetchedForSet("lastModified");
        this._persistence_propertyChange("lastModified", this.lastModified, date);
        this.lastModified = date;
    }
}

