/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.storage;

import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="DMSREVISIONSTORAGE")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class RevisionStorage<T extends StorageProvider>
extends Base
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date synchedOn;
    @ManyToOne(optional=false)
    @NotNull
    private Revision revision;
    @ManyToOne(optional=false)
    @NotNull
    private StorageProvider provider;
    static final long serialVersionUID = 5404747371429241168L;

    public RevisionStorage(T provider, Revision revision) {
        this.provider = provider;
        this.revision = revision;
    }

    public T getProvider() {
        return (T)this._persistence_get_provider();
    }

    public NodeStorage<T> getNodeStorage() {
        NodeStorage<T> nodeStorage = this.getRevision().getDocument().getNodeStorage(this.getProvider());
        return nodeStorage;
    }

    protected RevisionStorage() {
    }

    public Date getSynchedOn() {
        return this._persistence_get_synchedOn();
    }

    public Revision getRevision() {
        return this._persistence_get_revision();
    }

    public void setSynchedOn(Date synchedOn) {
        this._persistence_set_synchedOn(synchedOn);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RevisionStorage<T>(persistenceObject);
    }

    public RevisionStorage(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "provider") {
            return this.provider;
        }
        if (string == "synchedOn") {
            return this.synchedOn;
        }
        if (string == "revision") {
            return this.revision;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "provider") {
            this.provider = (StorageProvider)object;
            return;
        }
        if (string == "synchedOn") {
            this.synchedOn = (Date)object;
            return;
        }
        if (string == "revision") {
            this.revision = (Revision)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public StorageProvider _persistence_get_provider() {
        this._persistence_checkFetched("provider");
        return this.provider;
    }

    public void _persistence_set_provider(StorageProvider storageProvider) {
        this._persistence_checkFetchedForSet("provider");
        this._persistence_propertyChange("provider", this.provider, storageProvider);
        this.provider = storageProvider;
    }

    public Date _persistence_get_synchedOn() {
        this._persistence_checkFetched("synchedOn");
        return this.synchedOn;
    }

    public void _persistence_set_synchedOn(Date date) {
        this._persistence_checkFetchedForSet("synchedOn");
        this._persistence_propertyChange("synchedOn", this.synchedOn, date);
        this.synchedOn = date;
    }

    public Revision _persistence_get_revision() {
        this._persistence_checkFetched("revision");
        return this.revision;
    }

    public void _persistence_set_revision(Revision revision) {
        this._persistence_checkFetchedForSet("revision");
        this._persistence_propertyChange("revision", this.revision, revision);
        this.revision = revision;
    }
}

