/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.storage;

import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.storage.StorageProvider;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="DMSNODESTORAGE", uniqueConstraints={@UniqueConstraint(columnNames={"PROVIDER_ID", "NODE_ID"})})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class NodeStorage<T extends StorageProvider>
extends Base
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(NodeStorage.class);
    @ManyToOne(optional=false)
    @NotNull
    private StorageProvider provider;
    @ManyToOne(optional=false)
    @NotNull
    private Node node;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date synchedChange;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date synchedOn;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date synchStart;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date synchBeat;
    @Lob
    private String synchError;
    private Integer synchRetries;
    static final long serialVersionUID = -4004695233797055859L;

    public NodeStorage(T storageProvider, Node node) {
        this.node = node;
        this.provider = storageProvider;
    }

    public boolean isSynched() {
        return Objects.equals(this._persistence_get_synchedChange(), this._persistence_get_node().getChangedOn());
    }

    public T getProvider() {
        return (T)this._persistence_get_provider();
    }

    public boolean isSynching() {
        return this._persistence_get_synchStart() != null;
    }

    public void startSynch() {
        Validate.isTrue((!this.isSynching() ? 1 : 0) != 0, (String)"in synchig statuts", (Object[])new Object[0]);
        this._persistence_set_synchStart(new Date());
        this._persistence_set_synchBeat(new Date());
        if (this._persistence_get_synchRetries() != null) {
            Integer n = this._persistence_get_synchRetries();
            Integer n2 = this._persistence_get_synchRetries() + 1;
            this._persistence_set_synchRetries(n2);
            Integer n3 = n2;
        } else {
            this._persistence_set_synchRetries(0);
        }
        this._persistence_set_synchError(null);
    }

    public void continueSynch() {
        Validate.isTrue((boolean)this.isSynching(), (String)"not in synchig statuts", (Object[])new Object[0]);
        this._persistence_set_synchBeat(new Date());
    }

    public void completeSynch(Date nodeChangedOnDate) {
        this._persistence_set_synchStart(null);
        this._persistence_set_synchBeat(null);
        this._persistence_set_synchError(null);
        this._persistence_set_synchedOn(new Date());
        this._persistence_set_synchedChange(nodeChangedOnDate);
    }

    public void failSynch(@NonNull Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        Validate.isTrue((boolean)this.isSynching(), (String)"not in synchig statuts", (Object[])new Object[0]);
        this._persistence_set_synchStart(null);
        this._persistence_set_synchBeat(null);
        this._persistence_set_synchError(ExceptionUtils.getStackTrace((Throwable)t));
        if (this._persistence_get_synchRetries() > 10) {
            log.error(this + " failed synch. Retries = " + this._persistence_get_synchRetries(), t);
        }
    }

    public void restartSynch() {
        Validate.isTrue((boolean)this.isSynching(), (String)"not in synchig statuts", (Object[])new Object[0]);
        this._persistence_set_synchStart(new Date());
        this._persistence_set_synchBeat(new Date());
        Integer n = this._persistence_get_synchRetries();
        Integer n2 = this._persistence_get_synchRetries() + 1;
        this._persistence_set_synchRetries(n2);
        Integer n3 = n2;
    }

    public long getTimeSinceLastSynchBeat() {
        if (this.isSynching()) {
            return System.currentTimeMillis() - this._persistence_get_synchBeat().getTime();
        }
        return -1L;
    }

    protected NodeStorage() {
    }

    public Node getNode() {
        return this._persistence_get_node();
    }

    public Date getSynchedChange() {
        return this._persistence_get_synchedChange();
    }

    public Date getSynchedOn() {
        return this._persistence_get_synchedOn();
    }

    public Date getSynchStart() {
        return this._persistence_get_synchStart();
    }

    public Date getSynchBeat() {
        return this._persistence_get_synchBeat();
    }

    public String getSynchError() {
        return this._persistence_get_synchError();
    }

    public Integer getSynchRetries() {
        return this._persistence_get_synchRetries();
    }

    public void setSynchedChange(Date synchedChange) {
        this._persistence_set_synchedChange(synchedChange);
    }

    public void setSynchedOn(Date synchedOn) {
        this._persistence_set_synchedOn(synchedOn);
    }

    public void setSynchStart(Date synchStart) {
        this._persistence_set_synchStart(synchStart);
    }

    public void setSynchBeat(Date synchBeat) {
        this._persistence_set_synchBeat(synchBeat);
    }

    public void setSynchError(String synchError) {
        this._persistence_set_synchError(synchError);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NodeStorage<T>();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "synchedChange") {
            return this.synchedChange;
        }
        if (string == "synchBeat") {
            return this.synchBeat;
        }
        if (string == "synchError") {
            return this.synchError;
        }
        if (string == "node") {
            return this.node;
        }
        if (string == "synchStart") {
            return this.synchStart;
        }
        if (string == "provider") {
            return this.provider;
        }
        if (string == "synchedOn") {
            return this.synchedOn;
        }
        if (string == "synchRetries") {
            return this.synchRetries;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "synchedChange") {
            this.synchedChange = (Date)object;
            return;
        }
        if (string == "synchBeat") {
            this.synchBeat = (Date)object;
            return;
        }
        if (string == "synchError") {
            this.synchError = (String)object;
            return;
        }
        if (string == "node") {
            this.node = (Node)object;
            return;
        }
        if (string == "synchStart") {
            this.synchStart = (Date)object;
            return;
        }
        if (string == "provider") {
            this.provider = (StorageProvider)object;
            return;
        }
        if (string == "synchedOn") {
            this.synchedOn = (Date)object;
            return;
        }
        if (string == "synchRetries") {
            this.synchRetries = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_synchedChange() {
        this._persistence_checkFetched("synchedChange");
        return this.synchedChange;
    }

    public void _persistence_set_synchedChange(Date date) {
        this._persistence_checkFetchedForSet("synchedChange");
        this._persistence_propertyChange("synchedChange", this.synchedChange, date);
        this.synchedChange = date;
    }

    public Date _persistence_get_synchBeat() {
        this._persistence_checkFetched("synchBeat");
        return this.synchBeat;
    }

    public void _persistence_set_synchBeat(Date date) {
        this._persistence_checkFetchedForSet("synchBeat");
        this._persistence_propertyChange("synchBeat", this.synchBeat, date);
        this.synchBeat = date;
    }

    public String _persistence_get_synchError() {
        this._persistence_checkFetched("synchError");
        return this.synchError;
    }

    public void _persistence_set_synchError(String string) {
        this._persistence_checkFetchedForSet("synchError");
        this._persistence_propertyChange("synchError", this.synchError, string);
        this.synchError = string;
    }

    public Node _persistence_get_node() {
        this._persistence_checkFetched("node");
        return this.node;
    }

    public void _persistence_set_node(Node node) {
        this._persistence_checkFetchedForSet("node");
        this._persistence_propertyChange("node", this.node, node);
        this.node = node;
    }

    public Date _persistence_get_synchStart() {
        this._persistence_checkFetched("synchStart");
        return this.synchStart;
    }

    public void _persistence_set_synchStart(Date date) {
        this._persistence_checkFetchedForSet("synchStart");
        this._persistence_propertyChange("synchStart", this.synchStart, date);
        this.synchStart = date;
    }

    public StorageProvider _persistence_get_provider() {
        this._persistence_checkFetched("provider");
        return this.provider;
    }

    public void _persistence_set_provider(StorageProvider storageProvider) {
        this._persistence_checkFetchedForSet("provider");
        this._persistence_propertyChange("provider", this.provider, storageProvider);
        this.provider = storageProvider;
    }

    public Date _persistence_get_synchedOn() {
        this._persistence_checkFetched("synchedOn");
        return this.synchedOn;
    }

    public void _persistence_set_synchedOn(Date date) {
        this._persistence_checkFetchedForSet("synchedOn");
        this._persistence_propertyChange("synchedOn", this.synchedOn, date);
        this.synchedOn = date;
    }

    public Integer _persistence_get_synchRetries() {
        this._persistence_checkFetched("synchRetries");
        return this.synchRetries;
    }

    public void _persistence_set_synchRetries(Integer n) {
        this._persistence_checkFetchedForSet("synchRetries");
        this._persistence_propertyChange("synchRetries", this.synchRetries, n);
        this.synchRetries = n;
    }
}

