/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.mirror;

import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.mirror.DeviceInfo;
import com.anahata.yam.model.dms.mirror.MirrorType;
import com.anahata.yam.model.user.User;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="DMSMIRROR")
public class Mirror
extends Base
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @NotNull
    private String hostName;
    @NotNull
    @ManyToOne
    private User createdBy;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private MirrorType type;
    @NotNull
    private boolean active;
    private String macAddress;
    private String ipAddress;
    private String broadcastAddress;
    private String osUserName;
    private String osUserHome;
    private String dataDirectory;
    private String path;
    private String domain;
    private String userName;
    private String password;
    @ManyToMany(mappedBy="mirrors")
    @OrderBy(value="addedOn ASC")
    private List<Revision> revisionsPendingUpload;
    @OneToMany(mappedBy="workingCopyMirror")
    private List<Document> workingCopies;
    static final long serialVersionUID = 1595811500220397701L;

    public Mirror(@NonNull User user, @NonNull DeviceInfo di, @NonNull MirrorType type) {
        this.active = true;
        this.revisionsPendingUpload = new ArrayList<Revision>();
        this.workingCopies = new ArrayList<Document>();
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (di == null) {
            throw new NullPointerException("di");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.createdBy = user;
        this.macAddress = di.getMacAddress();
        this.hostName = di.getHostName();
        this.osUserHome = di.getOsUserHome();
        this.osUserName = di.getOsUserName();
        this.broadcastAddress = di.getBroadcastAddress();
        this.ipAddress = di.getIpAddress();
        this.type = type;
    }

    public void setMirrorType(MirrorType type) {
        this._persistence_set_type(type);
        if (type == MirrorType.LOCAL) {
            this._persistence_set_userName(null);
            this._persistence_set_password(null);
        }
    }

    @Override
    public String toString() {
        return "Mirror{hostName=" + this._persistence_get_hostName() + ", dataDirectory=" + this._persistence_get_dataDirectory() + '}';
    }

    public void setHostName(String hostName) {
        this._persistence_set_hostName(hostName);
    }

    public void setCreatedBy(User createdBy) {
        this._persistence_set_createdBy(createdBy);
    }

    public void setType(MirrorType type) {
        this._persistence_set_type(type);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setMacAddress(String macAddress) {
        this._persistence_set_macAddress(macAddress);
    }

    public void setIpAddress(String ipAddress) {
        this._persistence_set_ipAddress(ipAddress);
    }

    public void setBroadcastAddress(String broadcastAddress) {
        this._persistence_set_broadcastAddress(broadcastAddress);
    }

    public void setOsUserName(String osUserName) {
        this._persistence_set_osUserName(osUserName);
    }

    public void setOsUserHome(String osUserHome) {
        this._persistence_set_osUserHome(osUserHome);
    }

    public void setDataDirectory(String dataDirectory) {
        this._persistence_set_dataDirectory(dataDirectory);
    }

    public void setPath(String path) {
        this._persistence_set_path(path);
    }

    public void setDomain(String domain) {
        this._persistence_set_domain(domain);
    }

    public void setUserName(String userName) {
        this._persistence_set_userName(userName);
    }

    public void setPassword(String password) {
        this._persistence_set_password(password);
    }

    public void setRevisionsPendingUpload(List<Revision> revisionsPendingUpload) {
        this._persistence_set_revisionsPendingUpload(revisionsPendingUpload);
    }

    public void setWorkingCopies(List<Document> workingCopies) {
        this._persistence_set_workingCopies(workingCopies);
    }

    public String getHostName() {
        return this._persistence_get_hostName();
    }

    public User getCreatedBy() {
        return this._persistence_get_createdBy();
    }

    public MirrorType getType() {
        return this._persistence_get_type();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public String getMacAddress() {
        return this._persistence_get_macAddress();
    }

    public String getIpAddress() {
        return this._persistence_get_ipAddress();
    }

    public String getBroadcastAddress() {
        return this._persistence_get_broadcastAddress();
    }

    public String getOsUserName() {
        return this._persistence_get_osUserName();
    }

    public String getOsUserHome() {
        return this._persistence_get_osUserHome();
    }

    public String getDataDirectory() {
        return this._persistence_get_dataDirectory();
    }

    public String getPath() {
        return this._persistence_get_path();
    }

    public String getDomain() {
        return this._persistence_get_domain();
    }

    public String getUserName() {
        return this._persistence_get_userName();
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public List<Revision> getRevisionsPendingUpload() {
        return this._persistence_get_revisionsPendingUpload();
    }

    public List<Document> getWorkingCopies() {
        return this._persistence_get_workingCopies();
    }

    public Mirror() {
        this.active = true;
        this.revisionsPendingUpload = new ArrayList<Revision>();
        this.workingCopies = new ArrayList<Document>();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Mirror(persistenceObject);
    }

    public Mirror(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hostName") {
            return this.hostName;
        }
        if (string == "osUserHome") {
            return this.osUserHome;
        }
        if (string == "dataDirectory") {
            return this.dataDirectory;
        }
        if (string == "ipAddress") {
            return this.ipAddress;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "userName") {
            return this.userName;
        }
        if (string == "broadcastAddress") {
            return this.broadcastAddress;
        }
        if (string == "osUserName") {
            return this.osUserName;
        }
        if (string == "path") {
            return this.path;
        }
        if (string == "macAddress") {
            return this.macAddress;
        }
        if (string == "password") {
            return this.password;
        }
        if (string == "createdBy") {
            return this.createdBy;
        }
        if (string == "workingCopies") {
            return this.workingCopies;
        }
        if (string == "domain") {
            return this.domain;
        }
        if (string == "revisionsPendingUpload") {
            return this.revisionsPendingUpload;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hostName") {
            this.hostName = (String)object;
            return;
        }
        if (string == "osUserHome") {
            this.osUserHome = (String)object;
            return;
        }
        if (string == "dataDirectory") {
            this.dataDirectory = (String)object;
            return;
        }
        if (string == "ipAddress") {
            this.ipAddress = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "type") {
            this.type = (MirrorType)((Object)object);
            return;
        }
        if (string == "userName") {
            this.userName = (String)object;
            return;
        }
        if (string == "broadcastAddress") {
            this.broadcastAddress = (String)object;
            return;
        }
        if (string == "osUserName") {
            this.osUserName = (String)object;
            return;
        }
        if (string == "path") {
            this.path = (String)object;
            return;
        }
        if (string == "macAddress") {
            this.macAddress = (String)object;
            return;
        }
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "createdBy") {
            this.createdBy = (User)object;
            return;
        }
        if (string == "workingCopies") {
            this.workingCopies = (List)object;
            return;
        }
        if (string == "domain") {
            this.domain = (String)object;
            return;
        }
        if (string == "revisionsPendingUpload") {
            this.revisionsPendingUpload = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_hostName() {
        this._persistence_checkFetched("hostName");
        return this.hostName;
    }

    public void _persistence_set_hostName(String string) {
        this._persistence_checkFetchedForSet("hostName");
        this._persistence_propertyChange("hostName", this.hostName, string);
        this.hostName = string;
    }

    public String _persistence_get_osUserHome() {
        this._persistence_checkFetched("osUserHome");
        return this.osUserHome;
    }

    public void _persistence_set_osUserHome(String string) {
        this._persistence_checkFetchedForSet("osUserHome");
        this._persistence_propertyChange("osUserHome", this.osUserHome, string);
        this.osUserHome = string;
    }

    public String _persistence_get_dataDirectory() {
        this._persistence_checkFetched("dataDirectory");
        return this.dataDirectory;
    }

    public void _persistence_set_dataDirectory(String string) {
        this._persistence_checkFetchedForSet("dataDirectory");
        this._persistence_propertyChange("dataDirectory", this.dataDirectory, string);
        this.dataDirectory = string;
    }

    public String _persistence_get_ipAddress() {
        this._persistence_checkFetched("ipAddress");
        return this.ipAddress;
    }

    public void _persistence_set_ipAddress(String string) {
        this._persistence_checkFetchedForSet("ipAddress");
        this._persistence_propertyChange("ipAddress", this.ipAddress, string);
        this.ipAddress = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public MirrorType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(MirrorType mirrorType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", (Object)this.type, (Object)mirrorType);
        this.type = mirrorType;
    }

    public String _persistence_get_userName() {
        this._persistence_checkFetched("userName");
        return this.userName;
    }

    public void _persistence_set_userName(String string) {
        this._persistence_checkFetchedForSet("userName");
        this._persistence_propertyChange("userName", this.userName, string);
        this.userName = string;
    }

    public String _persistence_get_broadcastAddress() {
        this._persistence_checkFetched("broadcastAddress");
        return this.broadcastAddress;
    }

    public void _persistence_set_broadcastAddress(String string) {
        this._persistence_checkFetchedForSet("broadcastAddress");
        this._persistence_propertyChange("broadcastAddress", this.broadcastAddress, string);
        this.broadcastAddress = string;
    }

    public String _persistence_get_osUserName() {
        this._persistence_checkFetched("osUserName");
        return this.osUserName;
    }

    public void _persistence_set_osUserName(String string) {
        this._persistence_checkFetchedForSet("osUserName");
        this._persistence_propertyChange("osUserName", this.osUserName, string);
        this.osUserName = string;
    }

    public String _persistence_get_path() {
        this._persistence_checkFetched("path");
        return this.path;
    }

    public void _persistence_set_path(String string) {
        this._persistence_checkFetchedForSet("path");
        this._persistence_propertyChange("path", this.path, string);
        this.path = string;
    }

    public String _persistence_get_macAddress() {
        this._persistence_checkFetched("macAddress");
        return this.macAddress;
    }

    public void _persistence_set_macAddress(String string) {
        this._persistence_checkFetchedForSet("macAddress");
        this._persistence_propertyChange("macAddress", this.macAddress, string);
        this.macAddress = string;
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this._persistence_propertyChange("password", this.password, string);
        this.password = string;
    }

    public User _persistence_get_createdBy() {
        this._persistence_checkFetched("createdBy");
        return this.createdBy;
    }

    public void _persistence_set_createdBy(User user) {
        this._persistence_checkFetchedForSet("createdBy");
        this._persistence_propertyChange("createdBy", this.createdBy, user);
        this.createdBy = user;
    }

    public List _persistence_get_workingCopies() {
        this._persistence_checkFetched("workingCopies");
        return this.workingCopies;
    }

    public void _persistence_set_workingCopies(List list) {
        this._persistence_checkFetchedForSet("workingCopies");
        this._persistence_propertyChange("workingCopies", this.workingCopies, list);
        this.workingCopies = list;
    }

    public String _persistence_get_domain() {
        this._persistence_checkFetched("domain");
        return this.domain;
    }

    public void _persistence_set_domain(String string) {
        this._persistence_checkFetchedForSet("domain");
        this._persistence_propertyChange("domain", this.domain, string);
        this.domain = string;
    }

    public List _persistence_get_revisionsPendingUpload() {
        this._persistence_checkFetched("revisionsPendingUpload");
        return this.revisionsPendingUpload;
    }

    public void _persistence_set_revisionsPendingUpload(List list) {
        this._persistence_checkFetchedForSet("revisionsPendingUpload");
        this._persistence_propertyChange("revisionsPendingUpload", this.revisionsPendingUpload, list);
        this.revisionsPendingUpload = list;
    }
}

