/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.mirror;

import com.anahata.util.net.AnahataNetUtils;
import com.anahata.util.plaf.OSUtils;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DeviceInfo.class);
    private String macAddress;
    private String hostName;
    private String ipAddress;
    private String broadcastAddress;
    private String osUserName;
    private String osUserHome;

    public static DeviceInfo localDevice() {
        DeviceInfo di = new DeviceInfo();
        di.osUserName = OSUtils.getUserName();
        di.osUserHome = OSUtils.getUserHome();
        try {
            di.hostName = InetAddress.getLocalHost().getHostName();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni.isLoopback() || !ni.isUp()) continue;
                boolean accept = false;
                String macAddress = null;
                try {
                    macAddress = AnahataNetUtils.macToString((byte[])ni.getHardwareAddress());
                }
                catch (Exception e) {
                    log.debug("Could not retrieve mac address");
                }
                String ipAddress = null;
                String broadcastAddress = null;
                for (InterfaceAddress ifa : ni.getInterfaceAddresses()) {
                    InetAddress ia = ifa.getAddress();
                    if (!(ia instanceof Inet4Address)) continue;
                    try {
                        ipAddress = ((Inet4Address)ia).getHostAddress();
                        broadcastAddress = ((Inet4Address)ifa.getBroadcast()).getHostAddress();
                        accept = true;
                    }
                    catch (Exception e) {
                        log.debug("Discarding nic {}", (Object)ni.getDisplayName());
                    }
                }
                if (!accept) continue;
                di.macAddress = macAddress;
                di.ipAddress = ipAddress;
                di.broadcastAddress = broadcastAddress;
                di.macAddress = macAddress;
                break;
            }
        }
        catch (Throwable e) {
            log.error("Exception looking up network information", e);
            throw new RuntimeException(e);
        }
        log.debug("Local DeviceInfo {}", (Object)di);
        return di;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public String getOsUserHome() {
        return this.osUserHome;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setBroadcastAddress(String broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }

    public void setOsUserName(String osUserName) {
        this.osUserName = osUserName;
    }

    public void setOsUserHome(String osUserHome) {
        this.osUserHome = osUserHome;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$broadcastAddress = this.getBroadcastAddress();
        String other$broadcastAddress = other.getBroadcastAddress();
        if (this$broadcastAddress == null ? other$broadcastAddress != null : !this$broadcastAddress.equals(other$broadcastAddress)) {
            return false;
        }
        String this$osUserName = this.getOsUserName();
        String other$osUserName = other.getOsUserName();
        if (this$osUserName == null ? other$osUserName != null : !this$osUserName.equals(other$osUserName)) {
            return false;
        }
        String this$osUserHome = this.getOsUserHome();
        String other$osUserHome = other.getOsUserHome();
        return !(this$osUserHome == null ? other$osUserHome != null : !this$osUserHome.equals(other$osUserHome));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $broadcastAddress = this.getBroadcastAddress();
        result = result * 59 + ($broadcastAddress == null ? 43 : $broadcastAddress.hashCode());
        String $osUserName = this.getOsUserName();
        result = result * 59 + ($osUserName == null ? 43 : $osUserName.hashCode());
        String $osUserHome = this.getOsUserHome();
        result = result * 59 + ($osUserHome == null ? 43 : $osUserHome.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceInfo(macAddress=" + this.getMacAddress() + ", hostName=" + this.getHostName() + ", ipAddress=" + this.getIpAddress() + ", broadcastAddress=" + this.getBroadcastAddress() + ", osUserName=" + this.getOsUserName() + ", osUserHome=" + this.getOsUserHome() + ")";
    }
}

