/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms.databasebackup;

import com.anahata.util.io.AnahataFileUtils;
import com.anahata.util.plaf.OSUtils;
import com.anahata.util.props.StructuredProperties;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.commons.lang3.Validate;

public class DatabaseBackupConfig {
    private String cronExpression;
    private String executable;
    private String fileName;
    private String dateformat;
    private File location;
    private Integer keepDays;
    private String dmsUserName;

    public DatabaseBackupConfig(Properties props, String ... prefixes) {
        Validate.notNull((Object)props);
        StructuredProperties sprops = new StructuredProperties(props, prefixes);
        this.cronExpression = sprops.getString("cron.expression", "0 30 *");
        this.executable = sprops.getString("executable", null);
        this.fileName = sprops.getString("filename", "yam-backup");
        this.dateformat = sprops.getString("dateformat", "dd-MM-yyyy_HH-mm-ss");
        File defaultLocation = OSUtils.isLinux() ? new File("/opt/yam-backups") : AnahataFileUtils.getAnahataUserDirectory((String)"yam-backups");
        String locationStr = sprops.getString("location", null);
        this.location = locationStr != null ? new File(locationStr) : defaultLocation;
        this.keepDays = sprops.getInteger("keep.days", Integer.valueOf(7));
        this.dmsUserName = sprops.getString("dms.user.name", null);
    }

    public DateFormat getFormatter() {
        return this.dateformat != null ? new SimpleDateFormat(this.dateformat) : DateFormat.getDateTimeInstance(2, 2);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExecutable() {
        return this.executable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public File getLocation() {
        return this.location;
    }

    public Integer getKeepDays() {
        return this.keepDays;
    }

    public String getDmsUserName() {
        return this.dmsUserName;
    }

    private DatabaseBackupConfig() {
    }
}

